/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTileNoteLeft
implements TileWithUpdateStairs,
TileWithCallbackY {
    private final TileWithUpdateStairs tile;
    private final AbstractMessage message;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Display notes;
    private final LivingSpace livingSpace;

    public Event getEvent() {
        return this.message;
    }

    public CommunicationTileNoteLeft(TileWithUpdateStairs tileWithUpdateStairs, AbstractMessage abstractMessage, Skin skin, ISkinParam iSkinParam, LivingSpace livingSpace) {
        this.tile = tileWithUpdateStairs;
        this.message = abstractMessage;
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.notes = abstractMessage.getNote();
        this.livingSpace = livingSpace;
    }

    public void updateStairs(StringBounder stringBounder, double d) {
        this.tile.updateStairs(stringBounder, d);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.skin.createComponent(ComponentType.NOTE, null, this.message.getSkinParamNoteBackcolored(this.skinParam), this.notes);
        return component;
    }

    private Real getNotePosition(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return this.livingSpace.getPosC(stringBounder).addFixed(-dimension2D.getWidth());
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        Area area = new Area(dimension2D.getWidth(), dimension2D.getHeight());
        this.tile.drawU(uGraphic);
        Real real = this.getNotePosition(stringBounder);
        component.drawU(uGraphic.apply(new UTranslate(real.getCurrentValue(), 0.0)), area, (Context2D)((Object)uGraphic));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return Math.max(this.tile.getPreferredHeight(stringBounder), dimension2D.getHeight());
    }

    public void addConstraints(StringBounder stringBounder) {
        this.tile.addConstraints(stringBounder);
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.getNotePosition(stringBounder);
    }

    public Real getMaxX(StringBounder stringBounder) {
        return this.tile.getMaxX(stringBounder);
    }

    public void callbackY(double d) {
        if (this.tile instanceof TileWithCallbackY) {
            ((TileWithCallbackY)((Object)this.tile)).callbackY(d);
        }
    }
}

