/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ReferenceTile
implements Tile {
    private final Reference reference;
    private final TileArguments tileArguments;
    private Real first;
    private Real last;

    public Event getEvent() {
        return this.reference;
    }

    public ReferenceTile(Reference reference, TileArguments tileArguments) {
        this.reference = reference;
        this.tileArguments = tileArguments;
    }

    private void init(StringBounder stringBounder) {
        if (this.first != null) {
            return;
        }
        for (Participant object2 : this.reference.getParticipant()) {
            LivingSpace livingSpace = this.tileArguments.getLivingSpace(object2);
            Real real = livingSpace.getPosC(stringBounder);
            if (this.first == null || real.getCurrentValue() < this.first.getCurrentValue()) {
                this.first = livingSpace.getPosB();
            }
            if (this.last != null && !(real.getCurrentValue() > this.last.getCurrentValue())) continue;
            this.last = livingSpace.getPosD(stringBounder);
        }
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        if (this.reference.getParticipant().size() == 1) {
            this.last = this.last.addAtLeast(0.0);
        }
        this.last.ensureBiggerThan(this.first.addFixed(dimension2D.getWidth()));
    }

    private Component getComponent(StringBounder stringBounder) {
        Display display = Display.empty();
        display = display.add("ref");
        display = display.addAll(this.reference.getStrings());
        Component component = this.tileArguments.getSkin().createComponent(ComponentType.REFERENCE, null, this.tileArguments.getSkinParam(), display);
        return component;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        this.init(stringBounder);
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        Area area = new Area(this.last.getCurrentValue() - this.first.getCurrentValue(), dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(this.first.getCurrentValue(), 0.0));
        component.drawU(uGraphic, area, (Context2D)((Object)uGraphic));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    public void addConstraints(StringBounder stringBounder) {
    }

    public Real getMinX(StringBounder stringBounder) {
        this.init(stringBounder);
        return this.first;
    }

    public Real getMaxX(StringBounder stringBounder) {
        this.init(stringBounder);
        return this.last;
    }
}

