/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealOrigin;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.teoz.ComponentAdapter;
import net.sourceforge.plantuml.sequencediagram.teoz.Englobers;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.MainTile;
import net.sourceforge.plantuml.sequencediagram.teoz.MainTileAdapter;
import net.sourceforge.plantuml.sequencediagram.teoz.TeozLayer;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.utils.MathUtils;

public class SequenceDiagramFileMakerTeoz
implements FileMaker {
    private final SequenceDiagram diagram;
    private final FileFormatOption fileFormatOption;
    private final Skin skin;
    private Englobers englobers;
    private final StringBounder stringBounder = TextBlockUtils.getDummyStringBounder();
    private final TextBlock footer;
    private final TextBlock header;
    private final TextBlock main;
    private final TextBlock title;
    private final TextBlock legend;
    private final Dimension2D dimTotal;
    private final Real min1;
    private final LivingSpaces livingSpaces = new LivingSpaces();
    private final double heightEnglober1;
    private final double heightEnglober2;

    public SequenceDiagramFileMakerTeoz(SequenceDiagram sequenceDiagram, Skin skin, FileFormatOption fileFormatOption) {
        this.diagram = sequenceDiagram;
        this.fileFormatOption = fileFormatOption;
        this.skin = skin;
        this.footer = this.getFooterOrHeader(FontParam.FOOTER);
        this.header = this.getFooterOrHeader(FontParam.HEADER);
        this.main = new MainTileAdapter(this.createMainTile());
        this.min1 = ((MainTileAdapter)this.main).getMinX(this.stringBounder);
        this.title = this.getTitle();
        this.legend = this.getLegend();
        this.heightEnglober1 = this.englobers.getOffsetForEnglobers(this.stringBounder);
        this.heightEnglober2 = this.heightEnglober1 == 0.0 ? 0.0 : 10.0;
        double d = MathUtils.max(this.main.calculateDimension(this.stringBounder).getWidth(), this.title.calculateDimension(this.stringBounder).getWidth(), this.footer.calculateDimension(this.stringBounder).getWidth(), this.header.calculateDimension(this.stringBounder).getWidth(), this.legend.calculateDimension(this.stringBounder).getWidth());
        double d2 = this.main.calculateDimension(this.stringBounder).getHeight() + this.heightEnglober1 + this.heightEnglober2 + this.title.calculateDimension(this.stringBounder).getHeight() + this.header.calculateDimension(this.stringBounder).getHeight() + this.legend.calculateDimension(this.stringBounder).getHeight() + this.footer.calculateDimension(this.stringBounder).getHeight();
        this.dimTotal = new Dimension2DDouble(d, d2);
    }

    public ImageData createOne(OutputStream outputStream, int n, boolean bl) throws IOException {
        UTranslate uTranslate = new UTranslate(-this.min1.getCurrentValue(), 0.0);
        double d = this.diagram.getDpiFactor(this.fileFormatOption, this.dimTotal);
        UGraphic2 uGraphic2 = (UGraphic2)this.fileFormatOption.createUGraphic(this.getSkinParam().getColorMapper(), d, this.dimTotal, this.getSkinParam().getBackgroundColor(), false).apply(uTranslate);
        UGraphic uGraphic = this.getSkinParam().handwritten() ? new UGraphicHandwritten(uGraphic2) : uGraphic2;
        this.englobers.drawEnglobers(this.goDownForEnglobers(uGraphic), this.main.calculateDimension(this.stringBounder).getHeight() + this.heightEnglober1 + this.heightEnglober2 / 2.0, new SimpleContext2D(true));
        this.printAligned(uGraphic, this.diagram.getAlignmentTeoz(FontParam.HEADER), this.header);
        uGraphic = this.goDown(uGraphic, this.header);
        this.printAligned(uGraphic, HorizontalAlignment.CENTER, this.title);
        uGraphic = this.goDown(uGraphic, this.title);
        if (this.diagram.getLegendVerticalAlignment() == VerticalAlignment.TOP) {
            this.printAligned(uGraphic, this.diagram.getLegendAlignment(), this.legend);
            uGraphic = this.goDown(uGraphic, this.legend);
        }
        uGraphic = uGraphic.apply(new UTranslate(0.0, this.heightEnglober1));
        this.printAligned(uGraphic, HorizontalAlignment.CENTER, this.main);
        uGraphic = this.goDown(uGraphic, this.main);
        uGraphic = uGraphic.apply(new UTranslate(0.0, this.heightEnglober2));
        if (this.diagram.getLegendVerticalAlignment() == VerticalAlignment.BOTTOM) {
            this.printAligned(uGraphic, this.diagram.getLegendAlignment(), this.legend);
            uGraphic = this.goDown(uGraphic, this.legend);
        }
        this.printAligned(uGraphic, this.diagram.getAlignmentTeoz(FontParam.FOOTER), this.footer);
        uGraphic2.writeImageTOBEMOVED(outputStream, bl ? this.diagram.getMetadata() : null, this.diagram.getDpi(this.fileFormatOption));
        return new ImageDataSimple(this.dimTotal);
    }

    private UGraphic goDownForEnglobers(UGraphic uGraphic) {
        uGraphic = this.goDown(uGraphic, this.title);
        uGraphic = this.goDown(uGraphic, this.header);
        if (this.diagram.getLegendVerticalAlignment() == VerticalAlignment.TOP) {
            uGraphic = this.goDown(uGraphic, this.legend);
        }
        return uGraphic;
    }

    private UGraphic goDown(UGraphic uGraphic, TextBlock textBlock) {
        return uGraphic.apply(new UTranslate(0.0, textBlock.calculateDimension(this.stringBounder).getHeight()));
    }

    public void printAligned(UGraphic uGraphic, HorizontalAlignment horizontalAlignment, TextBlock textBlock) {
        double d = 0.0;
        if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            d = this.dimTotal.getWidth() - textBlock.calculateDimension(this.stringBounder).getWidth();
        } else if (horizontalAlignment == HorizontalAlignment.CENTER) {
            d = (this.dimTotal.getWidth() - textBlock.calculateDimension(this.stringBounder).getWidth()) / 2.0;
        }
        textBlock.drawU(uGraphic.apply(new UTranslate(d, 0.0)));
    }

    private MainTile createMainTile() {
        RealOrigin realOrigin = RealUtils.createOrigin();
        Real real = realOrigin.addAtLeast(0.0);
        for (Participant object2 : this.diagram.participants().values()) {
            LivingSpace livingSpace = new LivingSpace(object2, this.diagram.getEnglober(object2), this.skin, this.getSkinParam(), real, this.diagram.events());
            this.livingSpaces.put(object2, livingSpace);
            real = livingSpace.getPosD(this.stringBounder).addAtLeast(0.0);
        }
        TileArguments tileArguments = new TileArguments(this.stringBounder, this.livingSpaces, this.skin, this.diagram.getSkinParam(), realOrigin);
        this.englobers = new Englobers(tileArguments);
        MainTile mainTile = new MainTile(this.diagram, this.englobers, tileArguments);
        this.livingSpaces.addConstraints(this.stringBounder);
        mainTile.addConstraints(this.stringBounder);
        this.englobers.addConstraints(this.stringBounder);
        realOrigin.compileNow();
        tileArguments.setBordered(mainTile);
        return mainTile;
    }

    public ISkinParam getSkinParam() {
        return this.diagram.getSkinParam();
    }

    private TextBlock getTitle() {
        Display display = this.diagram.getTitle();
        if (Display.isNull(display)) {
            return new ComponentAdapter(null);
        }
        Component component = this.skin.createComponent(ComponentType.TITLE, null, this.getSkinParam(), display);
        return new ComponentAdapter(component);
    }

    private TextBlock getLegend() {
        Display display = this.diagram.getLegend();
        if (Display.isNull(display)) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return EntityImageLegend.create(display, this.diagram.getSkinParam());
    }

    public TextBlock getFooterOrHeader(FontParam fontParam) {
        Display display = this.diagram.getFooterOrHeaderTeoz(fontParam);
        if (Display.isNull(display)) {
            return new TeozLayer(null, this.stringBounder, fontParam);
        }
        HtmlColor htmlColor = this.getSkinParam().getHyperlinkColor();
        HtmlColor htmlColor2 = this.getSkinParam().getFontHtmlColor(null, fontParam);
        String string = this.getSkinParam().getFont(null, false, fontParam).getFamily(null);
        int n = this.getSkinParam().getFont(null, false, fontParam).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor2, display, n, string, this.diagram.getAlignmentTeoz(fontParam), htmlColor, this.getSkinParam().useUnderlineForHyperlink());
        return new TeozLayer(pngTitler, this.stringBounder, fontParam);
    }

    public int getNbPages() {
        return 1;
    }
}

