/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.sequencediagram.teoz.IntegerColored;
import net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stairs2 {
    private final List<StairsPosition> ys = new ArrayList<StairsPosition>();
    private final List<IntegerColored> values = new ArrayList<IntegerColored>();
    private final Map<Double, IntegerColored> cache = new HashMap<Double, IntegerColored>();

    public String toString() {
        return this.ys.toString() + " " + this.values;
    }

    public void addStep(StairsPosition stairsPosition, int n, SymbolContext symbolContext) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        assert (this.ys.size() == this.values.size());
        if (this.ys.size() > 0) {
            double d = this.ys.get(this.ys.size() - 1).getValue();
            if (stairsPosition.getValue() < d) {
                return;
            }
            if (d == stairsPosition.getValue()) {
                this.values.set(this.ys.size() - 1, new IntegerColored(n, symbolContext));
                this.cache.clear();
                return;
            }
        }
        this.ys.add(stairsPosition);
        this.values.add(new IntegerColored(n, symbolContext));
        this.cache.clear();
    }

    public int getMaxValue() {
        int n = Integer.MIN_VALUE;
        for (IntegerColored integerColored : this.values) {
            int n2 = integerColored.getValue();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public List<StairsPosition> getYs() {
        return Collections.unmodifiableList(this.ys);
    }

    public IntegerColored getValue(double d) {
        IntegerColored integerColored = this.cache.get(d);
        if (integerColored == null) {
            integerColored = this.getValueSlow(new StairsPosition(d, false));
            this.cache.put(d, integerColored);
        }
        return integerColored;
    }

    private IntegerColored getValueSlow(StairsPosition stairsPosition) {
        int n = Collections.binarySearch(this.ys, stairsPosition);
        if (n >= 0) {
            return this.values.get(n);
        }
        int n2 = -n - 1;
        if (n2 == 0) {
            return new IntegerColored(0, null);
        }
        return this.values.get(n2 - 1);
    }

    public int getLastValue() {
        int n = this.values.size();
        if (n == 0) {
            return 0;
        }
        return this.values.get(n - 1).getValue();
    }
}

