/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class StickMan
extends AbstractTextBlock
implements TextBlock {
    private final double armsY = 8.0;
    private final double armsLenght = 13.0;
    private final double bodyLenght = 27.0;
    private final double legsX = 13.0;
    private final double legsY = 15.0;
    private final double headDiam = 16.0;
    private final SymbolContext symbolContext;

    public StickMan(SymbolContext symbolContext) {
        this.symbolContext = symbolContext;
    }

    private StickMan(HtmlColor htmlColor, HtmlColor htmlColor2, double d) {
        this(new SymbolContext(htmlColor, htmlColor2).withDeltaShadow(d).withStroke(new UStroke(2.0)));
    }

    public StickMan(HtmlColor htmlColor, HtmlColor htmlColor2) {
        this(new SymbolContext(htmlColor, htmlColor2).withStroke(new UStroke(2.0)));
    }

    public void drawU(UGraphic uGraphic) {
        double d = Math.max(13.0, 13.0) - 8.0 + this.thickness();
        UEllipse uEllipse = new UEllipse(16.0, 16.0);
        double d2 = d + 8.0;
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 0.0);
        uPath.lineTo(0.0, 27.0);
        uPath.moveTo(-13.0, 8.0);
        uPath.lineTo(13.0, 8.0);
        uPath.moveTo(0.0, 27.0);
        uPath.lineTo(-13.0, 42.0);
        uPath.moveTo(0.0, 27.0);
        uPath.lineTo(13.0, 42.0);
        if (this.symbolContext.getDeltaShadow() != 0.0) {
            uEllipse.setDeltaShadow(this.symbolContext.getDeltaShadow());
            uPath.setDeltaShadow(this.symbolContext.getDeltaShadow());
        }
        uGraphic = this.symbolContext.apply(uGraphic);
        uGraphic.apply(new UTranslate(d, this.thickness())).draw(uEllipse);
        uGraphic.apply(new UTranslate(d2, 16.0 + this.thickness())).draw(uPath);
    }

    private double thickness() {
        return this.symbolContext.getStroke().getThickness();
    }

    public double getPreferredWidth() {
        return Math.max(13.0, 13.0) * 2.0 + 2.0 * this.thickness();
    }

    public double getPreferredHeight() {
        return 58.0 + 2.0 * this.thickness() + this.symbolContext.getDeltaShadow() + 1.0;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getPreferredWidth(), this.getPreferredHeight());
    }
}

