/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernGroupingHeader
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final int commentMargin = 0;
    private final TextBlock commentTextBlock;
    private final HtmlColor headerBackgroundColor;
    private final HtmlColor generalBackgroundColor;
    private final HtmlColor borderColor;

    public ComponentBlueModernGroupingHeader(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, HtmlColor htmlColor4, FontConfiguration fontConfiguration, UFont uFont, Display display, ISkinSimple iSkinSimple) {
        super(display.get(0), fontConfiguration, HorizontalAlignment.LEFT, 15, 30, 1, iSkinSimple, 0.0, null, null);
        this.headerBackgroundColor = htmlColor;
        this.generalBackgroundColor = htmlColor2;
        this.borderColor = htmlColor3;
        if (display.size() == 1 || display.get(1) == null) {
            this.commentTextBlock = null;
        } else {
            FontConfiguration fontConfiguration2 = new FontConfiguration(uFont, htmlColor4, fontConfiguration.getHyperlinkColor(), fontConfiguration.useUnderlineForHyperlink(), iSkinSimple.getTabSize());
            this.commentTextBlock = Display.create("[" + display.get(1) + "]").create(fontConfiguration2, HorizontalAlignment.LEFT, iSkinSimple);
        }
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d;
        if (this.commentTextBlock == null) {
            d = 0.0;
        } else {
            Dimension2D dimension2D = this.commentTextBlock.calculateDimension(stringBounder);
            d = (double)(this.getMarginX1() + 0) + dimension2D.getWidth();
        }
        return this.getTextWidth(stringBounder) + d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    protected void drawBackgroundInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic.apply(new UChangeColor(this.borderColor)).apply(new UStroke(2.0)).apply(new UChangeBackColor(this.generalBackgroundColor)).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic = uGraphic.apply(new UChangeColor(this.borderColor));
        uGraphic.apply(new UStroke(2.0)).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextWidth(stringBounder);
        int n2 = (int)this.getTextHeight(stringBounder);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(n, 0.0);
        uPolygon.addPoint(n, n2 - 10);
        uPolygon.addPoint(n - 10, n2);
        uPolygon.addPoint(0.0, n2);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic = uGraphic.apply(new UStroke(2.0));
        uGraphic = uGraphic.apply(new UChangeBackColor(this.headerBackgroundColor));
        uGraphic.draw(uPolygon);
        uGraphic.draw(new ULine(dimension2D.getWidth(), 0.0));
        double d = dimension2D.getHeight() - this.getPaddingY();
        uGraphic.apply(new UTranslate(dimension2D.getWidth(), 0.0)).draw(new ULine(0.0, d));
        uGraphic.apply(new UTranslate(0.0, n2)).draw(new ULine(0.0, d - (double)n2));
        uGraphic = uGraphic.apply(new UStroke());
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
        if (this.commentTextBlock != null) {
            int n3 = this.getMarginX1() + n;
            int n4 = this.getMarginY() + 1;
            this.commentTextBlock.drawU(uGraphic.apply(new UChangeColor(this.generalBackgroundColor)).apply(new UTranslate(n3 + 0, n4)));
        }
    }
}

