/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierActivity;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierState;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMakerSvek
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private static final StringBounder stringBounder;
    private String warningOrError;

    public CucaDiagramFileMakerSvek(CucaDiagram cucaDiagram) throws IOException {
        this.diagram = cucaDiagram;
    }

    @Override
    public ImageData createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        try {
            return this.createFileInternal(outputStream, list, fileFormatOption);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new IOException(interruptedException);
        }
    }

    private CucaDiagramFileMakerSvek2 buildCucaDiagramFileMakerSvek2(DotMode dotMode) {
        DotData dotData = new DotData(this.diagram.getEntityFactory().getRootGroup(), this.getOrderedLinks(), this.diagram.getLeafsvalues(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam(), this.diagram, this.diagram, this.diagram.getColorMapper(), this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState(), dotMode, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2 = new CucaDiagramFileMakerSvek2(dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma());
        return cucaDiagramFileMakerSvek2;
    }

    private ImageData createFileInternal(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            new CucaDiagramSimplifierActivity(this.diagram, list);
        } else if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            new CucaDiagramSimplifierState(this.diagram, list);
        }
        CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2 = this.buildCucaDiagramFileMakerSvek2(DotMode.NORMAL);
        TextBlockBackcolored textBlockBackcolored = cucaDiagramFileMakerSvek2.createFile(this.diagram.getDotStringSkek());
        if (textBlockBackcolored instanceof GraphvizCrash) {
            cucaDiagramFileMakerSvek2 = this.buildCucaDiagramFileMakerSvek2(DotMode.NO_LEFT_RIGHT);
            textBlockBackcolored = cucaDiagramFileMakerSvek2.createFile(this.diagram.getDotStringSkek());
        }
        textBlockBackcolored = this.addLegend(textBlockBackcolored);
        textBlockBackcolored = this.addTitle(textBlockBackcolored);
        textBlockBackcolored = this.addHeaderAndFooter(textBlockBackcolored);
        String string = this.diagram.getSkinParam().getValue("widthwarning");
        this.warningOrError = string != null && string.matches("\\d+") ? cucaDiagramFileMakerSvek2.getBibliotekon().getWarningOrError(Integer.parseInt(string)) : null;
        Dimension2D dimension2D = textBlockBackcolored.calculateDimension(stringBounder);
        double d = this.getScale(fileFormatOption, dimension2D);
        ImageBuilder imageBuilder = new ImageBuilder(this.diagram.getSkinParam().getColorMapper(), d, textBlockBackcolored.getBackcolor(), fileFormatOption.isWithMetadata() ? this.diagram.getMetadata() : null, this.warningOrError, 0.0, 10.0, this.diagram.getAnimation(), this.diagram.getSkinParam().handwritten());
        imageBuilder.addUDrawable(textBlockBackcolored);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, outputStream);
    }

    private List<Link> getOrderedLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            this.addLinkNew(arrayList, link);
        }
        return arrayList;
    }

    private void addLinkNew(List<Link> list, Link link) {
        for (int i = 0; i < list.size(); ++i) {
            Link link2 = list.get(i);
            if (!link2.sameConnections(link)) continue;
            while (i < list.size() && list.get(i).sameConnections(link)) {
                ++i;
            }
            if (i == list.size()) {
                list.add(link);
            } else {
                list.add(i, link);
            }
            return;
        }
        list.add(link);
    }

    private String getWarningOrError() {
        return this.warningOrError;
    }

    private TextBlockBackcolored addHeaderAndFooter(TextBlockBackcolored textBlockBackcolored) {
        Display display = this.diagram.getFooter();
        Display display2 = this.diagram.getHeader();
        if (Display.isNull(display) && Display.isNull(display2)) {
            return textBlockBackcolored;
        }
        TextBlock textBlock = Display.isNull(display) ? null : display.create(new FontConfiguration(this.diagram.getSkinParam(), FontParam.FOOTER, null), this.diagram.getFooterAlignment(), this.diagram.getSkinParam());
        TextBlock textBlock2 = Display.isNull(display2) ? null : display2.create(new FontConfiguration(this.diagram.getSkinParam(), FontParam.HEADER, null), this.diagram.getHeaderAlignment(), this.diagram.getSkinParam());
        return new DecorateEntityImage(textBlockBackcolored, textBlock2, this.diagram.getHeaderAlignment(), textBlock, this.diagram.getFooterAlignment());
    }

    private TextBlockBackcolored addTitle(TextBlockBackcolored textBlockBackcolored) {
        Display display = this.diagram.getTitle();
        if (Display.isNull(display)) {
            return textBlockBackcolored;
        }
        TextBlock textBlock = display.create(new FontConfiguration(this.diagram.getSkinParam(), FontParam.TITLE, null), HorizontalAlignment.CENTER, this.diagram.getSkinParam());
        return DecorateEntityImage.addTop(textBlockBackcolored, textBlock, HorizontalAlignment.CENTER);
    }

    private TextBlockBackcolored addLegend(TextBlockBackcolored textBlockBackcolored) {
        Display display = this.diagram.getLegend();
        if (Display.isNull(display)) {
            return textBlockBackcolored;
        }
        TextBlock textBlock = EntityImageLegend.create(display, this.diagram.getSkinParam());
        return DecorateEntityImage.add(textBlockBackcolored, textBlock, this.diagram.getLegendAlignment(), this.diagram.getLegendVerticalAlignment());
    }

    private final UFont getFont(FontParam fontParam) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFont(null, false, fontParam);
    }

    private final HtmlColor getFontColor(FontParam fontParam, Stereotype stereotype) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFontHtmlColor(stereotype, fontParam);
    }

    private double getScale(FileFormatOption fileFormatOption, Dimension2D dimension2D) {
        Scale scale = this.diagram.getScale();
        double d = scale == null ? this.diagram.getDpiFactor(fileFormatOption) : scale.getScale(dimension2D.getWidth(), dimension2D.getHeight());
        return d;
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        stringBounder = StringBounderUtils.asStringBounder(emptyImageBuilder.getGraphics2D());
    }
}

