/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.SkinParamForecolored;
import net.sourceforge.plantuml.SkinParamSameClassWidth;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2InternalImage;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.EntityImageProtected;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.SvekResult;
import net.sourceforge.plantuml.svek.image.EntityImageActivity;
import net.sourceforge.plantuml.svek.image.EntityImageArcCircle;
import net.sourceforge.plantuml.svek.image.EntityImageAssociation;
import net.sourceforge.plantuml.svek.image.EntityImageAssociationPoint;
import net.sourceforge.plantuml.svek.image.EntityImageBranch;
import net.sourceforge.plantuml.svek.image.EntityImageCircleEnd;
import net.sourceforge.plantuml.svek.image.EntityImageCircleStart;
import net.sourceforge.plantuml.svek.image.EntityImageClass;
import net.sourceforge.plantuml.svek.image.EntityImageDescription;
import net.sourceforge.plantuml.svek.image.EntityImageEmptyPackage;
import net.sourceforge.plantuml.svek.image.EntityImageGroup;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.svek.image.EntityImageObject;
import net.sourceforge.plantuml.svek.image.EntityImagePseudoState;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageState2;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.svek.image.EntityImageStateEmptyDescription;
import net.sourceforge.plantuml.svek.image.EntityImageSynchroBar;
import net.sourceforge.plantuml.svek.image.EntityImageTips;
import net.sourceforge.plantuml.svek.image.EntityImageUseCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMakerSvek2 {
    private final ColorSequence colorSequence = new ColorSequence();
    private final DotData dotData;
    private final EntityFactory entityFactory;
    private final UmlSource source;
    private final Pragma pragma;
    private static final StringBounder stringBounder;
    private DotStringFactory dotStringFactory;

    public CucaDiagramFileMakerSvek2(DotData dotData, EntityFactory entityFactory, UmlSource umlSource, Pragma pragma) {
        this.dotData = dotData;
        this.entityFactory = entityFactory;
        this.source = umlSource;
        this.pragma = pragma;
    }

    public Bibliotekon getBibliotekon() {
        return this.dotStringFactory.getBibliotekon();
    }

    public IEntityImage createFileForConcurrentState() {
        return new CucaDiagramFileMakerSvek2InternalImage(this.dotData.getLeafs(), this.dotData.getTopParent().getConcurrentSeparator(), this.dotData.getSkinParam(), this.dotData.getSkinParam().getBackgroundColor());
    }

    public IEntityImage createFile(String ... stringArray) {
        String string;
        Moveable moveable;
        Object exception;
        String illegalStateException;
        this.dotData.removeIrrelevantSametail();
        this.dotStringFactory = new DotStringFactory(this.colorSequence, stringBounder, this.dotData);
        this.printGroups(this.dotData.getRootGroup());
        this.printEntities(this.getUnpackagedEntities());
        for (Link object22 : this.dotData.getLinks()) {
            if (object22.isRemoved()) continue;
            try {
                Shape shape;
                Shape shape2;
                illegalStateException = this.getBibliotekon().getShapeUid((ILeaf)object22.getEntity1());
                exception = this.getBibliotekon().getShapeUid((ILeaf)object22.getEntity2());
                Cluster d = null;
                if (illegalStateException.startsWith("za")) {
                    d = this.getCluster2(object22.getEntity1());
                }
                Cluster cluster = null;
                if (((String)exception).startsWith("za")) {
                    cluster = this.getCluster2(object22.getEntity2());
                }
                ISkinParam d2 = this.dotData.getSkinParam();
                FontConfiguration fontConfiguration = new FontConfiguration(d2, FontParam.GENERIC_ARROW, null);
                moveable = new Line(illegalStateException, (String)exception, object22, this.colorSequence, d, cluster, d2, stringBounder, fontConfiguration, this.getBibliotekon(), this.dotStringFactory.getGraphvizVersion(), this.dotData.getPragma());
                this.getBibliotekon().addLine((Line)moveable);
                if (!object22.getEntity1().isGroup() && object22.getEntity1().getEntityType() == LeafType.NOTE && this.onlyOneLink(object22.getEntity1())) {
                    shape2 = this.getBibliotekon().getShape(object22.getEntity1());
                    shape = this.getBibliotekon().getShape(object22.getEntity2());
                    if (shape == null) continue;
                    ((EntityImageNote)shape2.getImage()).setOpaleLine((Line)moveable, shape2, shape);
                    ((Line)moveable).setOpale(true);
                    continue;
                }
                if (object22.getEntity2().isGroup() || object22.getEntity2().getEntityType() != LeafType.NOTE || !this.onlyOneLink(object22.getEntity2())) continue;
                shape2 = this.getBibliotekon().getShape(object22.getEntity2());
                shape = this.getBibliotekon().getShape(object22.getEntity1());
                if (shape == null) continue;
                ((EntityImageNote)shape2.getImage()).setOpaleLine((Line)moveable, shape2, shape);
                ((Line)moveable).setOpale(true);
            }
            catch (IllegalStateException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.dotStringFactory.illegalDotExe()) {
            return this.error(this.dotStringFactory.getDotExe());
        }
        boolean bl = OptionFlags.getInstance().isKeepTmpFiles() || this.isSvekTrace();
        try {
            string = this.dotStringFactory.getSvg(bl, stringArray);
        }
        catch (IOException iOException) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        if (string.length() == 0) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        illegalStateException = this.extractGraphvizVersion(string);
        try {
            exception = this.dotStringFactory.solve(string).delta(10.0, 10.0);
            double d = ((ClusterPosition)exception).getMinY();
            double d2 = ((ClusterPosition)exception).getMinX();
            if (d2 > 0.0 || d > 0.0) {
                throw new IllegalStateException();
            }
            moveable = new SvekResult((ClusterPosition)exception, this.dotData, this.dotStringFactory);
            ((SvekResult)moveable).moveSvek(6.0 - d2, -d);
            return moveable;
        }
        catch (Exception exception2) {
            Log.error("Exception " + exception2);
            throw new UnparsableGraphvizException(exception2, illegalStateException, string, this.source.getPlainString());
        }
    }

    private boolean isSvekTrace() {
        String string = this.pragma.getValue("svek_trace");
        return "true".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
    }

    private String extractGraphvizVersion(String string) {
        Pattern pattern = Pattern.compile("(?mi)!-- generated by graphviz(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return StringUtils.trin(matcher.group(1));
        }
        return null;
    }

    private boolean onlyOneLink(IEntity iEntity) {
        int n = 0;
        for (Link link : this.dotData.getLinks()) {
            if (link.isInvis()) continue;
            if (link.contains(iEntity)) {
                ++n;
            }
            if (n <= 1) continue;
            return false;
        }
        return n == 1;
    }

    private Cluster getCluster2(IEntity iEntity) {
        for (Cluster cluster : this.getBibliotekon().allCluster()) {
            if (iEntity != cluster.getGroup()) continue;
            return cluster;
        }
        throw new IllegalArgumentException();
    }

    private IEntityImage error(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Dot Executable: " + file);
        if (file != null) {
            if (!file.exists()) {
                arrayList.add("File does not exist");
            } else if (file.isDirectory()) {
                arrayList.add("It should be an executable, not a directory");
            } else if (!file.isFile()) {
                arrayList.add("Not a valid file");
            } else if (!file.canRead()) {
                arrayList.add("File cannot be read");
            }
        }
        arrayList.add("Cannot find Graphviz. You should try");
        arrayList.add(" ");
        arrayList.add("@startuml");
        arrayList.add("testdot");
        arrayList.add("@enduml");
        arrayList.add(" ");
        arrayList.add(" or ");
        arrayList.add(" ");
        arrayList.add("java -jar plantuml.jar -testdot");
        arrayList.add(" ");
        return GraphicStrings.createDefault(arrayList, false);
    }

    private void printEntities(Collection<ILeaf> collection) {
        for (ILeaf iLeaf : collection) {
            if (iLeaf.isRemoved()) continue;
            this.printEntity(iLeaf);
        }
    }

    private void printEntity(ILeaf iLeaf) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage iEntityImage = this.printEntityInternal(iLeaf);
        Dimension2D dimension2D = iEntityImage.calculateDimension(stringBounder);
        Shape shape = new Shape(iEntityImage, iEntityImage.getShapeType(), dimension2D.getWidth(), dimension2D.getHeight(), this.colorSequence, iLeaf.isTop(), iEntityImage.getShield(), iLeaf.getEntityPosition());
        this.dotStringFactory.addShape(shape);
        this.getBibliotekon().putShape(iLeaf, shape);
    }

    private IEntityImage printEntityInternal(ILeaf iLeaf) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (iLeaf.getSvekImage() == null) {
            ISkinParam iSkinParam = this.dotData.getSkinParam();
            if (this.dotData.getSkinParam().sameClassWidth()) {
                double d = this.getMaxWidth();
                iSkinParam = new SkinParamSameClassWidth(this.dotData.getSkinParam(), d);
            }
            return CucaDiagramFileMakerSvek2.createEntityImageBlock(iLeaf, iSkinParam, this.dotData.isHideEmptyDescriptionForState(), this.dotData, this.getBibliotekon(), this.dotStringFactory.getGraphvizVersion(), this.dotData.getUmlDiagramType());
        }
        return iLeaf.getSvekImage();
    }

    private double getMaxWidth() {
        double d = 0.0;
        for (ILeaf iLeaf : this.dotData.getLeafs()) {
            EntityImageClass entityImageClass;
            double d2;
            if (!iLeaf.getEntityType().isLikeClass() || !((d2 = (entityImageClass = new EntityImageClass(this.dotStringFactory.getGraphvizVersion(), iLeaf, this.dotData.getSkinParam(), this.dotData)).calculateDimension(stringBounder).getWidth()) > d)) continue;
            d = d2;
        }
        return d;
    }

    public static IEntityImage createEntityImageBlock(ILeaf iLeaf, ISkinParam iSkinParam, boolean bl, PortionShower portionShower, Bibliotekon bibliotekon, GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (iLeaf.getEntityType().isLikeClass()) {
            EntityImageClass entityImageClass = new EntityImageClass(graphvizVersion, iLeaf, iSkinParam, portionShower);
            Neighborhood neighborhood = iLeaf.getNeighborhood();
            if (neighborhood != null) {
                return new EntityImageProtected(entityImageClass, 20.0, neighborhood, bibliotekon);
            }
            return entityImageClass;
        }
        if (iLeaf.getEntityType() == LeafType.NOTE) {
            return new EntityImageNote(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.ACTIVITY) {
            return new EntityImageActivity(iLeaf, iSkinParam, bibliotekon);
        }
        if (iLeaf.getEntityType() == LeafType.STATE) {
            if (iLeaf.getEntityPosition() != EntityPosition.NORMAL) {
                Cluster cluster = bibliotekon.getCluster(iLeaf.getParentContainer());
                return new EntityImageStateBorder(iLeaf, iSkinParam, cluster, bibliotekon);
            }
            if (bl && iLeaf.getBodier().getFieldsToDisplay().size() == 0) {
                return new EntityImageStateEmptyDescription(iLeaf, iSkinParam);
            }
            if (iLeaf.getStereotype() != null && "<<sdlreceive>>".equals(iLeaf.getStereotype().getLabel(false))) {
                return new EntityImageState2(iLeaf, iSkinParam);
            }
            return new EntityImageState(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.CIRCLE_START) {
            ColorParam colorParam = ColorParam.activityStart;
            if (umlDiagramType == UmlDiagramType.STATE) {
                colorParam = ColorParam.stateStart;
            }
            return new EntityImageCircleStart(iLeaf, iSkinParam, colorParam);
        }
        if (iLeaf.getEntityType() == LeafType.CIRCLE_END) {
            ColorParam colorParam = ColorParam.activityEnd;
            if (umlDiagramType == UmlDiagramType.STATE) {
                colorParam = ColorParam.stateEnd;
            }
            return new EntityImageCircleEnd(iLeaf, iSkinParam, colorParam);
        }
        if (iLeaf.getEntityType() == LeafType.BRANCH || iLeaf.getEntityType() == LeafType.STATE_CHOICE) {
            return new EntityImageBranch(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.LOLLIPOP) {
            return new EntityImageLollipopInterface(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.DESCRIPTION) {
            return new EntityImageDescription(iLeaf, iSkinParam, portionShower);
        }
        if (iLeaf.getEntityType() == LeafType.USECASE) {
            return new EntityImageUseCase(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.OBJECT) {
            return new EntityImageObject(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.SYNCHRO_BAR || iLeaf.getEntityType() == LeafType.STATE_FORK_JOIN) {
            return new EntityImageSynchroBar(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.ARC_CIRCLE) {
            return new EntityImageArcCircle(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.POINT_FOR_ASSOCIATION) {
            return new EntityImageAssociationPoint(iLeaf, iSkinParam);
        }
        if (iLeaf.isGroup()) {
            return new EntityImageGroup(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.EMPTY_PACKAGE) {
            if (iLeaf.getUSymbol() != null) {
                return new EntityImageDescription(iLeaf, new SkinParamForecolored(iSkinParam, HtmlColorUtils.BLACK), portionShower);
            }
            return new EntityImageEmptyPackage(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.ASSOCIATION) {
            return new EntityImageAssociation(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.PSEUDO_STATE) {
            return new EntityImagePseudoState(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.TIPS) {
            return new EntityImageTips(iLeaf, iSkinParam, bibliotekon);
        }
        throw new UnsupportedOperationException(iLeaf.getEntityType().toString());
    }

    private Collection<ILeaf> getUnpackagedEntities() {
        ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>();
        for (ILeaf iLeaf : this.dotData.getLeafs()) {
            if (this.dotData.getTopParent() != iLeaf.getParentContainer()) continue;
            arrayList.add(iLeaf);
        }
        return arrayList;
    }

    private void printGroups(IGroup iGroup) {
        for (IGroup iGroup2 : this.dotData.getGroupHierarchy().getChildrenGroups(iGroup)) {
            if (iGroup2.isRemoved()) continue;
            if (this.dotData.isEmpty(iGroup2) && iGroup2.getGroupType() == GroupType.PACKAGE) {
                ILeaf iLeaf = this.entityFactory.createLeaf(iGroup2.getCode(), iGroup2.getDisplay(), LeafType.EMPTY_PACKAGE, iGroup2.getParentContainer(), null, this.dotData.getNamespaceSeparator());
                USymbol uSymbol = iGroup2.getUSymbol();
                iLeaf.setUSymbol(uSymbol);
                iLeaf.setStereotype(iGroup2.getStereotype());
                if (iGroup2.getColors(this.dotData.getSkinParam()).getColor(ColorType.BACK) == null) {
                    ColorParam colorParam = uSymbol == null ? ColorParam.packageBackground : uSymbol.getColorParamBack();
                    HtmlColor htmlColor = this.dotData.getSkinParam().getHtmlColor(colorParam, iGroup2.getStereotype(), false);
                    iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, htmlColor == null ? this.dotData.getSkinParam().getBackgroundColor() : htmlColor);
                } else {
                    iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, iGroup2.getColors(this.dotData.getSkinParam()).getColor(ColorType.BACK));
                }
                this.printEntity(iLeaf);
                continue;
            }
            this.printGroup(iGroup2);
        }
    }

    private void printGroup(IGroup iGroup) {
        if (iGroup.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        int n = 0;
        int n2 = 0;
        TextBlock textBlock = this.getTitleBlock(iGroup);
        TextBlock textBlock2 = this.getStereoBlock(iGroup);
        TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER);
        Dimension2D dimension2D = textBlock3.calculateDimension(stringBounder);
        if (dimension2D.getWidth() > 0.0) {
            List<Member> list = iGroup.getBodier().getFieldsToDisplay();
            AbstractTextBlock abstractTextBlock = list.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list, FontParam.STATE_ATTRIBUTE, this.dotData.getSkinParam());
            Dimension2D dimension2D2 = abstractTextBlock.calculateDimension(stringBounder);
            double d = dimension2D2.getHeight();
            double d2 = dimension2D2.getWidth();
            double d3 = d > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = iGroup.getUSymbol();
            int n3 = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int n4 = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            n = (int)Math.max(dimension2D.getWidth(), d2) + n4;
            n2 = (int)(dimension2D.getHeight() + d + d3 + (double)n3);
        }
        this.dotStringFactory.openCluster(iGroup, n, n2, textBlock, textBlock2);
        this.printEntities(iGroup.getLeafsDirect());
        this.printGroups(iGroup);
        this.dotStringFactory.closeCluster();
    }

    private TextBlock getTitleBlock(IGroup iGroup) {
        Display display = iGroup.getDisplay();
        if (display == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        ISkinParam iSkinParam = this.dotData.getSkinParam();
        FontConfiguration fontConfiguration = iGroup.getFontConfigurationForTitle(iSkinParam);
        return display.create(fontConfiguration, HorizontalAlignment.CENTER, iSkinParam);
    }

    private TextBlock getStereoBlock(IGroup iGroup) {
        Stereotype stereotype = iGroup.getStereotype();
        if (stereotype == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        if (stereotype.getSprite() != null) {
            return this.dotData.getSkinParam().getSprite(stereotype.getSprite()).asTextBlock(stereotype.getHtmlColor());
        }
        List<String> list = stereotype.getLabels(this.dotData.getSkinParam().useGuillemet());
        if (list == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        boolean bl = this.dotData.showPortion(EntityPortion.STEREOTYPE, iGroup);
        if (!bl) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        FontParam fontParam = FontParam.PACKAGE_STEREOTYPE;
        return Display.create(list).create(new FontConfiguration(this.dotData.getSkinParam(), fontParam, stereotype), HorizontalAlignment.CENTER, this.dotData.getSkinParam());
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        stringBounder = StringBounderUtils.asStringBounder(emptyImageBuilder.getGraphics2D());
    }
}

