/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.EntityImageClassHeader2;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageClass
extends AbstractEntityImage
implements Stencil {
    private final TextBlock body;
    private final int shield;
    private final EntityImageClassHeader2 header;
    private final Url url;
    private final double roundCorner;
    private final LineConfigurable lineConfig;

    public EntityImageClass(GraphvizVersion graphvizVersion, ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iLeaf.getColors(iSkinParam).mute(iSkinParam));
        this.lineConfig = iLeaf;
        this.roundCorner = this.getSkinParam().getRoundCorner();
        this.shield = graphvizVersion != null && graphvizVersion.useShield() && iLeaf.hasNearDecoration() ? 16 : 0;
        boolean bl = portionShower.showPortion(EntityPortion.METHOD, iLeaf);
        boolean bl2 = portionShower.showPortion(EntityPortion.FIELD, iLeaf);
        this.body = iLeaf.getBodier().getBody(FontParam.CLASS_ATTRIBUTE, this.getSkinParam(), bl, bl2);
        this.header = new EntityImageClassHeader2(iLeaf, this.getSkinParam(), portionShower);
        this.url = iLeaf.getUrl99();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.header.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.body == null ? new Dimension2DDouble(0.0, 0.0) : this.body.calculateDimension(stringBounder);
        double d = Math.max(dimension2D2.getWidth(), dimension2D.getWidth());
        if (d < this.getSkinParam().minClassWidth()) {
            d = this.getSkinParam().minClassWidth();
        }
        double d2 = dimension2D2.getHeight() + dimension2D.getHeight();
        return new Dimension2DDouble(d, d2);
    }

    public Rectangle2D getInnerPosition(String string, StringBounder stringBounder) {
        Rectangle2D rectangle2D = this.body.getInnerPosition(string, stringBounder);
        if (rectangle2D == null) {
            return rectangle2D;
        }
        Dimension2D dimension2D = this.header.calculateDimension(stringBounder);
        UTranslate uTranslate = new UTranslate(0.0, dimension2D.getHeight());
        return uTranslate.apply(rectangle2D);
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        this.drawInternal(uGraphic);
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    private void drawInternal(UGraphic uGraphic) {
        Object object;
        HtmlColor htmlColor;
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.header.calculateDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d, d2, this.roundCorner, this.roundCorner);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        if ((htmlColor = this.lineConfig.getColors(this.getSkinParam()).getColor(ColorType.LINE)) == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor));
        HtmlColor htmlColor2 = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (htmlColor2 == null) {
            htmlColor2 = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor2));
        UStroke uStroke = this.getStroke();
        uGraphic.apply(uStroke).draw(uRectangle);
        HtmlColor htmlColor3 = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.HEADER);
        if (htmlColor3 == null) {
            htmlColor3 = this.getSkinParam().getHtmlColor(ColorParam.classHeaderBackground, this.getStereo(), false);
        }
        if (htmlColor3 != null) {
            object = new URectangle(d, dimension2D2.getHeight());
            uGraphic.apply(new UChangeBackColor(htmlColor3)).apply(uStroke).draw((UShape)object);
        }
        this.header.drawU(uGraphic, dimension2D.getWidth(), dimension2D2.getHeight());
        if (this.body != null) {
            object = new UGraphicStencil(uGraphic, this, uStroke);
            UTranslate uTranslate = new UTranslate(0.0, dimension2D2.getHeight());
            this.body.drawU(object.apply(uTranslate));
        }
    }

    private UStroke getStroke() {
        UStroke uStroke = this.lineConfig.getColors(this.getSkinParam()).getSpecificLineStroke();
        if (uStroke == null) {
            uStroke = this.getSkinParam().getThickness(LineParam.classBorder, this.getStereo());
        }
        if (uStroke == null) {
            uStroke = new UStroke(1.5);
        }
        return uStroke;
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return this.shield;
    }

    public double getStartingX(StringBounder stringBounder, double d) {
        return 0.0;
    }

    public double getEndingX(StringBounder stringBounder, double d) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

