/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import net.sourceforge.plantuml.DirWatcher2;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.swing.AboutWindow;
import net.sourceforge.plantuml.swing.ImageWindow2;
import net.sourceforge.plantuml.swing.SimpleLine2;
import net.sourceforge.plantuml.swing.SpriteWindow;
import net.sourceforge.plantuml.version.PSystemVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWindow2
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(MainWindow2.class);
    private static final String KEY_DIR = "cur";
    private static final String KEY_PATTERN = "pat";
    private final JList jList1 = new JList();
    private final JScrollPane scrollPane;
    private final JButton changeDirButton = new JButton("Change Directory");
    private final JTextField extensions = new JTextField();
    private final int period = 300;
    private final List<SimpleLine2> currentDirectoryListing2 = new ArrayList<SimpleLine2>();
    private final Set<ImageWindow2> openWindows2 = new HashSet<ImageWindow2>();
    private final Option option;
    private DirWatcher2 dirWatcher;

    private String getExtensions() {
        return prefs.get(KEY_PATTERN, this.getDefaultFileExtensions());
    }

    private String getDefaultFileExtensions() {
        return "txt, tex, java, htm, html, c, h, cpp, apt, pu";
    }

    private void changeExtensions(String string) {
        if (string.equals(this.getExtensions())) {
            return;
        }
        Pattern pattern = Pattern.compile("\\w+");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string2);
        }
        string = stringBuilder.toString();
        if (string.length() == 0) {
            string = this.getDefaultFileExtensions();
        }
        this.extensions.setText(string);
        prefs.put(KEY_PATTERN, string);
        this.changeDir(this.dirWatcher.getDir());
    }

    private String getRegexpPattern(String string) {
        Pattern pattern = Pattern.compile("\\w+");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder("(?i)^.*\\.(");
        while (matcher.find()) {
            String string2 = matcher.group();
            if (!stringBuilder.toString().endsWith("(")) {
                stringBuilder.append("|");
            }
            stringBuilder.append(string2);
        }
        if (!stringBuilder.toString().endsWith("(")) {
            stringBuilder.append(")$");
            return stringBuilder.toString();
        }
        return Option.getPattern();
    }

    public MainWindow2(Option option, File file) {
        super(MainWindow2.getDirectory(file).getAbsolutePath());
        File file2 = MainWindow2.getDirectory(file);
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.option = option;
        this.dirWatcher = new DirWatcher2(file2, option, this.getRegexpPattern(this.getExtensions()));
        Log.info("Showing MainWindow");
        this.scrollPane = new JScrollPane(this.jList1);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("File extensions: ");
        this.extensions.setText(this.getExtensions());
        jLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createEtchedBorder());
        compoundBorder = BorderFactory.createCompoundBorder(compoundBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setBorder(compoundBorder);
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.extensions, "Center");
        jPanel.add((Component)this.changeDirButton, "South");
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = MainWindow2.this.jList1.locationToIndex(mouseEvent.getPoint());
                        MainWindow2.this.doubleClick((SimpleLine2)MainWindow2.this.jList1.getModel().getElementAt(n), MainWindow2.this.jList1.getModel(), n);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.jList1.addMouseListener(mouseAdapter);
        this.changeDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.err.println("Opening Directory Window");
                MainWindow2.this.displayDialogChangeDir();
            }
        });
        this.jList1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    int n = MainWindow2.this.jList1.getSelectedIndex();
                    MainWindow2.this.doubleClick((SimpleLine2)MainWindow2.this.jList1.getModel().getElementAt(n), MainWindow2.this.jList1.getModel(), n);
                }
            }
        });
        this.extensions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow2.this.changeExtensions(MainWindow2.this.extensions.getText());
            }
        });
        this.extensions.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                MainWindow2.this.changeExtensions(MainWindow2.this.extensions.getText());
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        JMenuItem jMenuItem = new JMenuItem("Open Sprite Window");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new SpriteWindow();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("About");
        jMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AboutWindow();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Exit");
        jMenu.add(jMenuItem3);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.setSize(640, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.startTimer();
    }

    private static File getDirectory(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            return file;
        }
        return new File(prefs.get(KEY_DIR, "."));
    }

    private void startTimer() {
        Log.info("Init done");
        Timer timer = new Timer(300, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow2.this.tick();
            }
        });
        timer.setInitialDelay(0);
        timer.start();
        Log.info("Timer started");
    }

    private void displayDialogChangeDir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(2);
        jFileChooser.setDialogTitle("Directory to watch:");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        String string = prefs.get(KEY_DIR, ".");
        jFileChooser.setCurrentDirectory(new File(string));
        Log.info("Showing OpenDialog");
        int n = jFileChooser.showOpenDialog(this);
        Log.info("Closing OpenDialog");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.changeDir(file);
        }
    }

    private void changeDir(File file) {
        prefs.put(KEY_DIR, file.getAbsolutePath());
        this.dirWatcher.cancel();
        this.dirWatcher = new DirWatcher2(file, this.option, this.getRegexpPattern(this.getExtensions()));
        this.setTitle(file.getAbsolutePath());
        Log.info("Creating DirWatcher");
        this.currentDirectoryListing2.clear();
        this.jList1.setListData(new Vector<SimpleLine2>(this.currentDirectoryListing2));
        this.jList1.setVisible(true);
    }

    private void doubleClick(SimpleLine2 simpleLine2, ListModel listModel, int n) {
        for (ImageWindow2 imageWindow2 : this.openWindows2) {
            if (!imageWindow2.getSimpleLine().equals(simpleLine2)) continue;
            imageWindow2.setVisible(true);
            imageWindow2.setExtendedState(0);
            return;
        }
        if (simpleLine2.getGeneratedImage() != null) {
            this.openWindows2.add(new ImageWindow2(simpleLine2, this, listModel, n));
        }
    }

    private void tick() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    boolean bl = MainWindow2.this.refreshDir();
                    if (bl) {
                        MainWindow2.this.jList1.setListData(new Vector(MainWindow2.this.currentDirectoryListing2));
                        MainWindow2.this.jList1.setVisible(true);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        });
    }

    private boolean refreshDir() throws IOException, InterruptedException, ExecutionException {
        Object object;
        Map<File, Future<List<GeneratedImage>>> map = this.dirWatcher.buildCreatedFiles();
        boolean bl = false;
        for (Map.Entry<File, Future<List<GeneratedImage>>> object2 : map.entrySet()) {
            object = object2.getKey();
            this.removeAllThatUseThisFile((File)object);
            Future<List<GeneratedImage>> future = object2.getValue();
            Comparable<SimpleLine2> comparable = SimpleLine2.fromFuture((File)object, future);
            this.currentDirectoryListing2.add((SimpleLine2)comparable);
            bl = true;
        }
        for (SimpleLine2 simpleLine2 : new ArrayList<SimpleLine2>(this.currentDirectoryListing2)) {
            if (!simpleLine2.pendingAndFinished()) continue;
            this.currentDirectoryListing2.remove(simpleLine2);
            bl = true;
            object = simpleLine2.getFuture();
            for (Comparable<SimpleLine2> comparable : (List)object.get()) {
                this.mayRefreshImageWindow(comparable.getPngFile());
                SimpleLine2 simpleLine22 = SimpleLine2.fromGeneratedImage(simpleLine2.getFile(), comparable);
                this.currentDirectoryListing2.add(simpleLine22);
            }
        }
        Collections.sort(this.currentDirectoryListing2);
        return bl;
    }

    private void removeAllThatUseThisFile(File file) {
        Iterator<SimpleLine2> iterator = this.currentDirectoryListing2.iterator();
        while (iterator.hasNext()) {
            SimpleLine2 simpleLine2 = iterator.next();
            if (!simpleLine2.getFile().equals(file)) continue;
            iterator.remove();
        }
    }

    private void mayRefreshImageWindow(File file) {
        for (ImageWindow2 imageWindow2 : this.openWindows2) {
            if (imageWindow2.getSimpleLine().getGeneratedImage() == null || !file.equals(imageWindow2.getSimpleLine().getGeneratedImage().getPngFile())) continue;
            imageWindow2.refreshImage(true);
        }
    }

    public void closing(ImageWindow2 imageWindow2) {
        boolean bl = this.openWindows2.remove(imageWindow2);
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public List<SimpleLine2> getCurrentDirectoryListing2() {
        return Collections.unmodifiableList(this.currentDirectoryListing2);
    }
}

