/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

public class SpriteImage
implements Sprite {
    private final UImage img;

    public SpriteImage(BufferedImage bufferedImage) {
        this.img = new UImage(bufferedImage);
    }

    public TextBlock asTextBlock(HtmlColor htmlColor) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                uGraphic.draw(SpriteImage.this.img);
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(SpriteImage.this.img.getWidth(), SpriteImage.this.img.getHeight());
            }
        };
    }

    public static Sprite fromInternal(String string) {
        if (string.endsWith(".png")) {
            throw new IllegalArgumentException();
        }
        InputStream inputStream = SpriteImage.getInternalSprite(string + ".png");
        if (inputStream == null) {
            return null;
        }
        try {
            return new SpriteImage(ImageIO.read(inputStream));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static InputStream getInternalSprite(String string) {
        String string2 = "/sprites/" + string;
        InputStream inputStream = SpriteImage.class.getResourceAsStream(string2);
        return inputStream;
    }
}

