/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.PlacementStrategy;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ULayoutGroup {
    private final PlacementStrategy placementStrategy;

    public ULayoutGroup(PlacementStrategy placementStrategy) {
        this.placementStrategy = placementStrategy;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        for (Map.Entry<TextBlock, Point2D> entry : this.placementStrategy.getPositions(d, d2).entrySet()) {
            TextBlock textBlock = entry.getKey();
            Point2D point2D = entry.getValue();
            textBlock.drawU(uGraphic.apply(new UTranslate(point2D)));
        }
    }

    public void add(TextBlock textBlock) {
        this.placementStrategy.add(textBlock);
    }

    public Rectangle2D getInnerPosition(String string, double d, double d2, StringBounder stringBounder) {
        for (Map.Entry<TextBlock, Point2D> entry : this.placementStrategy.getPositions(d, d2).entrySet()) {
            TextBlock textBlock = entry.getKey();
            Rectangle2D rectangle2D = textBlock.getInnerPosition(string, stringBounder);
            if (rectangle2D == null) continue;
            UTranslate uTranslate = new UTranslate(entry.getValue());
            return uTranslate.apply(rectangle2D);
        }
        return null;
    }
}

