/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import net.sourceforge.plantuml.Log;

public class DriverShadowedG2d {
    private final Color color = new Color(170, 170, 170);
    private final Color colorLine = new Color(30, 30, 30);

    private ConvolveOp getConvolveOp(int n, double d) {
        n = (int)((double)n * d);
        int n2 = n * n;
        float f = n2;
        float f2 = (float)(1.0 / (double)f);
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = f2;
        }
        Kernel kernel = new Kernel(n, n, fArray);
        return new ConvolveOp(kernel, 1, null);
    }

    protected void drawShadow(Graphics2D graphics2D, Shape shape, double d, double d2) {
        Object object;
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d3 = rectangle2D.getMaxX() - rectangle2D.getMinX();
        double d4 = rectangle2D.getMaxY() - rectangle2D.getMinY();
        double d5 = (d3 + d * 2.0 + 6.0) * d2;
        double d6 = (d4 + d * 2.0 + 6.0) * d2;
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage((int)d5, (int)d6, 2);
            object = bufferedImage.createGraphics();
            ((Graphics2D)object).scale(d2, d2);
            ((Graphics2D)object).translate(d - rectangle2D.getMinX(), d - rectangle2D.getMinY());
            boolean bl = shape instanceof Line2D.Double;
            if (bl) {
                ((Graphics)object).setColor(this.colorLine);
                ((Graphics2D)object).draw(shape);
            } else {
                ((Graphics)object).setColor(this.color);
                ((Graphics2D)object).fill(shape);
            }
            ((Graphics)object).dispose();
            ConvolveOp convolveOp = this.getConvolveOp(6, d2);
            bufferedImage = convolveOp.filter(bufferedImage, null);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.info("Warning: Cannot draw shadow, image too big.");
        }
        catch (Exception exception) {
            Log.info("Warning: Cannot draw shadow: " + exception);
        }
        if (bufferedImage != null) {
            object = graphics2D.getTransform();
            graphics2D.scale(1.0 / d2, 1.0 / d2);
            graphics2D.drawImage((Image)bufferedImage, (int)(rectangle2D.getMinX() * d2), (int)(rectangle2D.getMinY() * d2), null);
            graphics2D.setTransform((AffineTransform)object);
        }
    }
}

