/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.hand;

import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.hand.HandJiggle;

public class URectangleHand {
    private final UPolygon poly;

    public URectangleHand(URectangle uRectangle) {
        HandJiggle handJiggle;
        double d = uRectangle.getWidth();
        double d2 = uRectangle.getHeight();
        double d3 = Math.min(uRectangle.getRx() / 2.0, d / 2.0);
        double d4 = Math.min(uRectangle.getRy() / 2.0, d2 / 2.0);
        if (d3 == 0.0 && d4 == 0.0) {
            handJiggle = new HandJiggle(0.0, 0.0, 1.5);
            handJiggle.lineTo(d, 0.0);
            handJiggle.lineTo(d, d2);
            handJiggle.lineTo(0.0, d2);
            handJiggle.lineTo(0.0, 0.0);
        } else {
            handJiggle = new HandJiggle(d3, 0.0, 1.5);
            handJiggle.lineTo(d - d3, 0.0);
            handJiggle.arcTo(-1.5707963267948966, 0.0, d - d3, d4, d3, d4);
            handJiggle.lineTo(d, d2 - d4);
            handJiggle.arcTo(0.0, 1.5707963267948966, d - d3, d2 - d4, d3, d4);
            handJiggle.lineTo(d3, d2);
            handJiggle.arcTo(1.5707963267948966, Math.PI, d3, d2 - d4, d3, d4);
            handJiggle.lineTo(0.0, d4);
            handJiggle.arcTo(Math.PI, 4.71238898038469, d3, d4, d3, d4);
        }
        this.poly = handJiggle.toUPolygon();
        this.poly.setDeltaShadow(uRectangle.getDeltaShadow());
    }

    public Shadowable getHanddrawn() {
        return this.poly;
    }
}

