/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UFontContext;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTextSvg
implements UDriver<SvgGraphics> {
    private final StringBounder stringBounder;
    private final ClipContainer clipContainer;

    public DriverTextSvg(StringBounder stringBounder, ClipContainer clipContainer) {
        this.stringBounder = stringBounder;
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, SvgGraphics svgGraphics) {
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null && !uClip.isInside(d, d2)) {
            return;
        }
        UText uText = (UText)uShape;
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        UFont uFont = fontConfiguration.getFont();
        String string = null;
        if (fontConfiguration.containsStyle(FontStyle.BOLD) || uFont.isBold()) {
            string = "bold";
        }
        String string2 = null;
        if (fontConfiguration.containsStyle(FontStyle.ITALIC) || uFont.isItalic()) {
            string2 = "italic";
        }
        String string3 = null;
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            string3 = "underline";
        } else if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            string3 = "line-through";
        }
        String string4 = null;
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
            string4 = StringUtils.getAsHtml(colorMapper.getMappedColor(fontConfiguration.getExtendedColor()));
        }
        svgGraphics.setFillColor(StringUtils.getAsHtml(colorMapper.getMappedColor(fontConfiguration.getColor())));
        String string5 = uText.getText();
        if (string5.startsWith(" ")) {
            double d3 = this.stringBounder.calculateDimension(uFont, " ").getWidth();
            while (string5.startsWith(" ")) {
                d += d3;
                string5 = string5.substring(1);
            }
        }
        string5 = StringUtils.trin(string5);
        Dimension2D dimension2D = this.stringBounder.calculateDimension(uFont, string5);
        svgGraphics.text(string5, d, d2, uFont.getFamily(UFontContext.SVG), uFont.getSize(), string, string2, string3, dimension2D.getWidth(), fontConfiguration.getAttributes(), string4);
    }
}

