/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;

public class StartUtils {
    public static final String PAUSE_PATTERN = "(?i)((?:\\W|\\<[^<>]*\\>)*)@unpause";
    public static final String START_PATTERN = "(?i)((?:[^\\w~]|\\<[^<>]*\\>)*)@start";
    private static final Pattern append = MyPattern.cmpile("^\\W*@append");

    public static boolean isArobaseStartDiagram(CharSequence charSequence) {
        return StringUtils.trinNoTrace(charSequence).startsWith("@start");
    }

    public static boolean isArobaseEndDiagram(CharSequence charSequence) {
        return StringUtils.trinNoTrace(charSequence).startsWith("@end");
    }

    public static boolean isArobasePauseDiagram(CharSequence charSequence) {
        return StringUtils.trinNoTrace(charSequence).startsWith("@pause");
    }

    public static boolean isArobaseUnpauseDiagram(CharSequence charSequence) {
        return StringUtils.trinNoTrace(charSequence).startsWith("@unpause");
    }

    public static CharSequence2 getPossibleAppend(CharSequence2 charSequence2) {
        Matcher matcher = append.matcher(charSequence2);
        if (matcher.find()) {
            return charSequence2.subSequence(matcher.group(0).length(), charSequence2.length()).trin();
        }
        return null;
    }
}

