/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.plantuml.webp.Globals;
import net.sourceforge.plantuml.webp.VP8Frame;

public class VP8Decoder {
    private int[][][][] coefProbs = Globals.getDefaultCoefProbs();
    VP8Frame f;
    private int frameCount = 0;

    public void decodeFrame(ImageInputStream imageInputStream, boolean bl) throws IOException {
        this.coefProbs = Globals.getDefaultCoefProbs();
        this.f = new VP8Frame(imageInputStream, this.coefProbs);
        if (this.f.decodeFrame(bl)) {
            // empty if block
        }
        ++this.frameCount;
    }

    public VP8Frame getFrame() {
        return this.f;
    }

    public int getHeight() {
        return this.f.getHeight();
    }

    public int getWidth() {
        return this.f.getWidth();
    }

    private void writeFile(int[][] nArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("outagain.raw");
            for (int i = 0; i < nArray[0].length; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    fileOutputStream.write(nArray[j][i]);
                    fileOutputStream.write(nArray[j][i]);
                    fileOutputStream.write(nArray[j][i]);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writePGMFile(String string, VP8Frame vP8Frame) {
        try {
            int n;
            int n2;
            int[][] nArray = vP8Frame.getYBuffer();
            int[][] nArray2 = vP8Frame.getUBuffer();
            int[][] nArray3 = vP8Frame.getVBuffer();
            int n3 = this.f.getWidth() + 1 & 0xFFFFFFFE;
            int n4 = (this.f.getHeight() + 1) / 2;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(80);
            fileOutputStream.write(53);
            fileOutputStream.write(10);
            fileOutputStream.write(("" + n3).getBytes());
            fileOutputStream.write(32);
            fileOutputStream.write(("" + (this.f.getHeight() + n4)).getBytes());
            fileOutputStream.write(10);
            fileOutputStream.write("255".getBytes());
            fileOutputStream.write(10);
            for (n2 = 0; n2 < this.f.getHeight(); ++n2) {
                for (n = 0; n < this.f.getWidth(); ++n) {
                    fileOutputStream.write(nArray[n][n2]);
                }
                if ((this.f.getWidth() & 1) != 1) continue;
                fileOutputStream.write(0);
            }
            for (n2 = 0; n2 < (this.f.getHeight() + 1) / 2; ++n2) {
                for (n = 0; n < (this.f.getWidth() + 1) / 2; ++n) {
                    fileOutputStream.write(nArray2[n][n2]);
                }
                for (n = 0; n < (this.f.getWidth() + 1) / 2; ++n) {
                    fileOutputStream.write(nArray3[n][n2]);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeYV12File(String string, VP8Frame vP8Frame) {
        try {
            int n;
            int n2;
            int[][] nArray = vP8Frame.getYBuffer();
            int[][] nArray2 = vP8Frame.getUBuffer();
            int[][] nArray3 = vP8Frame.getVBuffer();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(80);
            fileOutputStream.write(53);
            fileOutputStream.write(10);
            fileOutputStream.write(("" + this.f.getWidth()).getBytes());
            fileOutputStream.write(32);
            fileOutputStream.write(("" + this.f.getHeight() * 3 / 2).getBytes());
            fileOutputStream.write(10);
            fileOutputStream.write("255".getBytes());
            fileOutputStream.write(10);
            for (n2 = 0; n2 < this.f.getHeight(); ++n2) {
                for (n = 0; n < this.f.getWidth(); ++n) {
                    fileOutputStream.write(nArray[n][n2]);
                }
            }
            for (n2 = 0; n2 < (this.f.getHeight() + 1) / 2; ++n2) {
                for (n = 0; n < (this.f.getWidth() + 1) / 2; ++n) {
                    fileOutputStream.write(nArray2[n][n2]);
                }
            }
            for (n2 = 0; n2 < (this.f.getHeight() + 1) / 2; ++n2) {
                for (n = 0; n < (this.f.getWidth() + 1) / 2; ++n) {
                    fileOutputStream.write(nArray3[n][n2]);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

