/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilerContext;
import apex.jorje.semantic.compiler.CompilerStage;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;

class CompilerStageProcessor {
    private final CompilerContext compilerContext;
    private final Map<CompilerStage, Queue<CodeUnit>> stagesToUnits;
    private final Deque<CompilerStage> currentStages;

    CompilerStageProcessor(CompilerContext compilerContext) {
        this.compilerContext = compilerContext;
        this.stagesToUnits = CompilerStageProcessor.createStageToUnitMap();
        this.currentStages = Queues.newArrayDeque();
    }

    private static Map<CompilerStage, Queue<CodeUnit>> createStageToUnitMap() {
        EnumMap stagesToUnits = new EnumMap(CompilerStage.class);
        for (CompilerStage stage : CompilerStage.values()) {
            stagesToUnits.put(stage, Queues.newLinkedBlockingQueue());
        }
        return Maps.immutableEnumMap(stagesToUnits);
    }

    void addUnit(CodeUnit unit) {
        this.stagesToUnits.get((Object)CompilerStage.WAITING).add(unit);
    }

    void addUnits(Collection<CodeUnit> units) {
        this.stagesToUnits.get((Object)CompilerStage.WAITING).addAll(units);
    }

    CompilerStage getCurrentStage() {
        Optional<CompilerStage> current = Optional.ofNullable(this.currentStages.peek());
        return current.map(CompilerStage::getPrevious).orElse(CompilerStage.EMIT);
    }

    boolean allUnitsEmitted() {
        return this.allUnitsAtStage(CompilerStage.EMIT);
    }

    @VisibleForTesting
    boolean allUnitsAtStage(CompilerStage atStage) {
        Objects.requireNonNull(atStage, "stage provided was null");
        for (CompilerStage stage : CompilerStage.values()) {
            if (atStage == stage) {
                return true;
            }
            if (this.stagesToUnits.get((Object)stage).isEmpty()) continue;
            return false;
        }
        throw new UnexpectedCodePathException();
    }

    void processToStage(CompilerStage atStage) {
        Objects.requireNonNull(atStage, "stage provided was null");
        this.compilerContext.getLocalContexts().push(new CompilerContext.LocalContext());
        try {
            while (this.processFirstStage(atStage)) {
            }
        }
        finally {
            this.compilerContext.getLocalContexts().pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFirstStage(CompilerStage atStage) {
        CompilerStage[] values;
        if (atStage == CompilerStage.WAITING) {
            return false;
        }
        for (CompilerStage stage : values = CompilerStage.values()) {
            if (stage == atStage) {
                return false;
            }
            if (this.stagesToUnits.get((Object)stage).isEmpty()) continue;
            CodeUnit unitToProcess = this.stagesToUnits.get((Object)stage).poll();
            CompilerStage nextStage = stage.getNext();
            this.currentStages.push(nextStage);
            try {
                this.compilerContext.getCompilerProgressCallback().reportProgress(nextStage.name());
                nextStage.getOperation().invoke(this.compilerContext, unitToProcess);
            }
            finally {
                this.currentStages.pop();
            }
            this.stagesToUnits.get((Object)nextStage).add(unitToProcess);
            return true;
        }
        throw new UnexpectedCodePathException();
    }
}

