/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.PolymorphicTypes;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;

public class InstanceOfExpression
extends Expression {
    private final TypeRef typeRef;
    private final Expression expression;
    private final Location loc;
    private TypeInfo type;

    public InstanceOfExpression(AstNode definingNode, Expr.InstanceOf expr) {
        super(definingNode);
        this.typeRef = expr.type;
        this.loc = Locations.from(expr);
        this.expression = AstNodes.get().create((AstNode)this, expr.expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        Errors errors = scope.getErrors();
        if (errors.isInvalid(this.expression) || this.typeRef == null) {
            errors.markInvalid(this);
            return;
        }
        this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        if (!this.type.isResolved()) {
            errors.markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
            return;
        }
        if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.type, Visibility.ReferencedFromTestMethod.fromBoolean(scope.isTestMethod()), Visibility.CheckGenericTypeArguments.YES)) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
            return;
        }
        boolean isAssignable = Distance.get().canAssign(this.getDefiningType(), this.expression.getType(), this.type) && SObjectTypeInfoUtil.isSObjectList(this.expression.getType()) == SObjectTypeInfoUtil.isSObjectList(this.type);
        boolean hasNoVersioningInformation = this.expression.getType().getCodeUnitDetails().getInterfacePackageVersions().isEmpty();
        if (!(!isAssignable || !hasNoVersioningInformation || TypeInfoEquivalence.isEquivalent(this.expression.getType(), TypeInfos.STRING) && TypeInfoEquivalence.isEquivalent(this.type, TypeInfos.ID) || SObjectTypeInfoUtil.isSObjectList(this.expression.getType()) && SObjectTypeInfoUtil.isSObjectList(this.type) && Distance.get().canAssign(this.getDefiningType(), CollectionTypeInfoUtil.getElementType(this.type), CollectionTypeInfoUtil.getElementType(this.expression.getType())) || !PolymorphicTypes.getPolymorphicTypes(this.expression).isEmpty())) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.instanceof.always.true", this.expression.getType(), this.type));
            return;
        }
        if (!this.expression.getType().getBasicType().canBeCastOrInstanceOf()) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.instanceof.invalid.type", this.expression.getType()));
        } else if (!isAssignable && !PolymorphicTypes.isAssignable(this.getDefiningType(), this.type, this.expression) && this.expression.getType().getUnitType() != UnitType.INTERFACE && this.type.getUnitType() != UnitType.INTERFACE) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.instanceof.always.false", this.expression.getType(), this.type));
            return;
        }
        this.setType(TypeInfos.BOOLEAN);
    }

    @Override
    public void emit(Emitter emitter) {
        this.expression.emit(emitter);
        if (TypeInfoEquivalence.isEquivalent(this.expression.getType(), TypeInfos.STRING) && TypeInfoEquivalence.isEquivalent(this.type, TypeInfos.ID)) {
            emitter.emit(this.loc, SystemEmitMethods.STRING_INSTANCE_OF_ID);
        } else {
            emitter.push(this.loc, TypeEraser.eraseBytecodeName(this.type));
            emitter.emit(this.loc, SystemEmitMethods.INSTANCE_OF);
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public TypeInfo getInstanceOfType() {
        return this.type;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }
}

