/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.StringEmitMethods;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfos;
import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.List;

class StringConcatenation {
    private static final int BIGGEST_APPEND_SIZE = 6;
    private static final int ESTIMATED_CONSTANT_STRING_MAX_LENGTH_ALLOWED = 21800;
    private static final AstVisitor<BooleanScope> IS_STRING = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(LiteralExpression node, BooleanScope scope) {
            scope.setValue(node.getLiteralType() == LiteralType.STRING);
        }
    };
    private final AstNode definingNode;
    private final Emitter emitter;

    public StringConcatenation(AstNode definingNode, Emitter emitter) {
        this.definingNode = definingNode;
        this.emitter = emitter;
    }

    static void emitLiteral(LiteralExpression definingNode, Emitter emitter, String value) {
        if (value.length() >= 21800 && value.getBytes(Charset.forName("UTF-8")).length >= 65536) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int startIdx = 0; startIdx < value.length(); startIdx += 21800) {
                int endIdx = Math.min(startIdx + 21800, value.length());
                LiteralExpression newExpression = new LiteralExpression(definingNode, new Expr.LiteralExpr(definingNode.getLoc(), LiteralType.STRING, value.substring(startIdx, endIdx)));
                newExpression.setType(TypeInfos.STRING);
                builder.add(newExpression);
            }
            StringConcatenation concatenation = new StringConcatenation(definingNode, emitter);
            concatenation.emit((List<Expression>)((Object)builder.build()));
        } else {
            emitter.push(definingNode.getLoc(), value);
        }
    }

    private static boolean isStringLiteral(Expression expression) {
        return BooleanScope.evaluate(expression, IS_STRING, false);
    }

    static List<Expression> coalesceAdjoiningStringLiterals(AstNode definingNode, int estimatedConstantStringMaxLengthAllowed, List<Expression> expressions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (i < expressions.size()) {
            if (StringConcatenation.isStringLiteral(expressions.get(i))) {
                String value;
                StringBuilder stringBuilder = new StringBuilder();
                int firstExpressionIndex = i;
                stringBuilder.append(StringConcatenation.getString(expressions.get(i)));
                ++i;
                while (i < expressions.size() && StringConcatenation.isStringLiteral(expressions.get(i)) && (value = StringConcatenation.getString(expressions.get(i))).length() + stringBuilder.length() <= estimatedConstantStringMaxLengthAllowed) {
                    stringBuilder.append(value);
                    ++i;
                }
                LiteralExpression newExpression = new LiteralExpression(definingNode, new Expr.LiteralExpr(expressions.get(firstExpressionIndex).getLoc(), LiteralType.STRING, stringBuilder.toString()));
                newExpression.setType(TypeInfos.STRING);
                builder.add(newExpression);
                continue;
            }
            builder.add(expressions.get(i++));
        }
        return builder.build();
    }

    private static String getString(Expression stringLiteralExpression) {
        return (String)ExpressionUtil.getLiteralExpression(stringLiteralExpression).getLiteral();
    }

    public void emit(List<Expression> allExpressions) {
        List<Expression> expressions = StringConcatenation.coalesceAdjoiningStringLiterals(this.definingNode, 21800, allExpressions);
        Location firstLoc = expressions.get(0).getLoc();
        if (expressions.size() <= 36) {
            int outerAppends = (expressions.size() - 1) / 6 + 1;
            for (int i = 0; i < outerAppends; ++i) {
                int last = Math.min(expressions.size(), (i + 1) * 6);
                int innerAppends = last - i * 6;
                for (int j = i * 6; j < last; ++j) {
                    expressions.get(j).emit(this.emitter);
                    this.emitToString(expressions.get(j));
                }
                if (innerAppends <= 1) continue;
                this.emitter.emit(firstLoc, StringEmitMethods.append(innerAppends));
            }
            if (outerAppends > 1) {
                this.emitter.emit(firstLoc, StringEmitMethods.append(outerAppends));
            }
        } else {
            this.emitter.emitType(firstLoc, 187, ReifiedTypeInfos.STRING_LIST.getBytecodeName());
            this.emitter.emit(firstLoc, 89);
            this.emitter.emit(firstLoc, ObjectEmitMethods.constructor(ReifiedTypeInfos.STRING_LIST));
            for (Expression expression : expressions) {
                this.emitter.emit(expression.getLoc(), 89);
                expression.emit(this.emitter);
                this.emitToString(expression);
                this.emitter.emit(expression.getLoc(), ListEmitMethods.addNoReturn(TypeInfos.LIST));
            }
            this.emitter.emit(firstLoc, StringEmitMethods.JOIN);
        }
    }

    private void emitToString(final Expression expression) {
        if (!expression.getType().equals(TypeInfos.STRING)) {
            expression.traverse(new AstVisitor<Scope>(){

                private void convertToInteger() {
                    TypeConversion.emit(expression.getLoc(), StringConcatenation.this.emitter, expression.getType(), TypeInfos.INTEGER);
                }

                @Override
                public void visitEnd(PrefixExpression node, Scope scope) {
                    if (node.getOp().isIncOrDec()) {
                        this.convertToInteger();
                    }
                }

                @Override
                public void visitEnd(PostfixExpression node, Scope scope) {
                    this.convertToInteger();
                }
            }, NoopScope.get());
            this.emitter.emit(expression.getLoc(), StringEmitMethods.VALUE_OF);
        }
    }
}

