/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.Compilation;
import com.nawforce.common.diagnostics.Issue;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.apex.ApexLanguageProcessor;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClassOrInterface;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;
import net.sourceforge.pmd.lang.apex.multifile.ApexMultifileAnalysis;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ASTApexFile
extends AbstractApexNode<AstNode>
implements RootNode {
    private final AstInfo<ASTApexFile> astInfo;
    private final @NonNull ApexMultifileAnalysis multifileAnalysis;

    ASTApexFile(Parser.ParserTask task, Compilation jorjeNode, Map<Integer, String> suppressMap, @NonNull ApexLanguageProcessor apexLang) {
        super(jorjeNode);
        this.astInfo = new AstInfo(task, (RootNode)this).withSuppressMap(suppressMap);
        this.multifileAnalysis = apexLang.getMultiFileState();
        this.setRegion(TextRegion.fromOffsetLength((int)0, (int)task.getTextDocument().getLength()));
    }

    public AstInfo<ASTApexFile> getAstInfo() {
        return this.astInfo;
    }

    @Override
    public double getApexVersion() {
        return this.getNode().getDefiningType().getCodeUnitDetails().getVersion().getExternal();
    }

    public ASTUserClassOrInterface<?> getMainNode() {
        return (ASTUserClassOrInterface)this.getChild(0);
    }

    @Override
    public @NonNull ASTApexFile getRoot() {
        return this;
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public List<Issue> getGlobalIssues() {
        String filename = this.getAstInfo().getTextDocument().getPathId();
        if (filename.length() > 7 && "file://".equalsIgnoreCase(filename.substring(0, 7))) {
            URI uri = URI.create(filename);
            filename = Paths.get(uri).toString();
        }
        return this.multifileAnalysis.getFileIssues(filename);
    }
}

