/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.Identifier;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ASTMethodCallExpression
extends AbstractApexNode<MethodCallExpression> {
    ASTMethodCallExpression(MethodCallExpression methodCallExpression) {
        super(methodCallExpression);
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public String getMethodName() {
        return ((MethodCallExpression)this.node).getMethodName();
    }

    public String getFullMethodName() {
        String methodName = this.getMethodName();
        StringBuilder typeName = new StringBuilder();
        for (Identifier identifier : ((MethodCallExpression)this.node).getReferenceContext().getNames()) {
            typeName.append(identifier.getValue()).append('.');
        }
        return typeName.toString() + methodName;
    }

    public int getInputParametersSize() {
        return ((MethodCallExpression)this.node).getInputParameters().size();
    }

    @Override
    public @NonNull TextRegion getTextRegion() {
        int fullLength = this.getFullMethodName().length();
        int nameLength = this.getMethodName().length();
        TextRegion base = super.getTextRegion();
        if (fullLength > nameLength) {
            base = base.growLeft(fullLength - nameLength);
        }
        return base;
    }
}

