/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.services.exception.ParseException;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.apex.ApexJorjeLogging;
import net.sourceforge.pmd.lang.apex.ApexLanguageProcessor;
import net.sourceforge.pmd.lang.apex.ast.ASTApexFile;
import net.sourceforge.pmd.lang.apex.ast.ApexTreeBuilder;
import net.sourceforge.pmd.lang.apex.ast.CompilerService;
import net.sourceforge.pmd.lang.ast.Parser;

@InternalApi
public final class ApexParser
implements Parser {
    public ApexParser() {
        ApexJorjeLogging.disableLogging();
        Locations.useIndexFactory();
    }

    public ASTApexFile parse(Parser.ParserTask task) {
        try {
            Compilation astRoot = CompilerService.INSTANCE.parseApex(task.getTextDocument());
            assert (astRoot != null) : "Normally replaced by Compilation.INVALID";
            ApexTreeBuilder treeBuilder = new ApexTreeBuilder(task, (ApexLanguageProcessor)task.getLanguageProcessor());
            return treeBuilder.buildTree(astRoot);
        }
        catch (ParseException e) {
            throw new net.sourceforge.pmd.lang.ast.ParseException((Throwable)e).setFileName(task.getFileDisplayName());
        }
    }
}

