/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AnonymousClass;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.ConstructorPreamble;
import apex.jorje.semantic.ast.compilation.InvalidDependentCompilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserClassMethods;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserExceptionMethods;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.condition.StandardCondition;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.AssignmentExpression;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.BindExpressions;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.ClassRefExpression;
import apex.jorje.semantic.ast.expression.EmptyReferenceExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IllegalStoreExpression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.JavaMethodCallExpression;
import apex.jorje.semantic.ast.expression.JavaVariableExpression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MapEntryNode;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NestedExpression;
import apex.jorje.semantic.ast.expression.NestedStoreExpression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.PackageVersionExpression;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SoslExpression;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.SuperVariableExpression;
import apex.jorje.semantic.ast.expression.TernaryExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisVariableExpression;
import apex.jorje.semantic.ast.expression.TriggerVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.Modifier;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.BreakStatement;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.ConstructorPreambleStatement;
import apex.jorje.semantic.ast.statement.ContinueStatement;
import apex.jorje.semantic.ast.statement.DmlDeleteStatement;
import apex.jorje.semantic.ast.statement.DmlInsertStatement;
import apex.jorje.semantic.ast.statement.DmlMergeStatement;
import apex.jorje.semantic.ast.statement.DmlUndeleteStatement;
import apex.jorje.semantic.ast.statement.DmlUpdateStatement;
import apex.jorje.semantic.ast.statement.DmlUpsertStatement;
import apex.jorje.semantic.ast.statement.DoLoopStatement;
import apex.jorje.semantic.ast.statement.ElseWhenBlock;
import apex.jorje.semantic.ast.statement.ExpressionStatement;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.ForEachStatement;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.IfBlockStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.MethodBlockStatement;
import apex.jorje.semantic.ast.statement.MultiStatement;
import apex.jorje.semantic.ast.statement.ReturnStatement;
import apex.jorje.semantic.ast.statement.RunAsBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.StatementExecuted;
import apex.jorje.semantic.ast.statement.SwitchStatement;
import apex.jorje.semantic.ast.statement.ThrowStatement;
import apex.jorje.semantic.ast.statement.TryCatchFinallyBlockStatement;
import apex.jorje.semantic.ast.statement.TypeWhenBlock;
import apex.jorje.semantic.ast.statement.ValueWhenBlock;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.statement.VariableDeclarationStatements;
import apex.jorje.semantic.ast.statement.WhenCases;
import apex.jorje.semantic.ast.statement.WhileLoopStatement;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.exception.Errors;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ApexLanguageProcessor;
import net.sourceforge.pmd.lang.apex.ApexLanguageProperties;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotationParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTAnonymousClass;
import net.sourceforge.pmd.lang.apex.ast.ASTApexFile;
import net.sourceforge.pmd.lang.apex.ast.ASTArrayLoadExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTArrayStoreExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBindExpressions;
import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTBooleanExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTBridgeMethodCreator;
import net.sourceforge.pmd.lang.apex.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTCatchBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTClassRefExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTCommentContainer;
import net.sourceforge.pmd.lang.apex.ast.ASTConstructorPreamble;
import net.sourceforge.pmd.lang.apex.ast.ASTConstructorPreambleStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlDeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlInsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlMergeStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUndeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpdateStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDoLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTElseWhenBlock;
import net.sourceforge.pmd.lang.apex.ast.ASTEmptyReferenceExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclarationStatements;
import net.sourceforge.pmd.lang.apex.ast.ASTForEachStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTFormalComment;
import net.sourceforge.pmd.lang.apex.ast.ASTIdentifierCase;
import net.sourceforge.pmd.lang.apex.ast.ASTIfBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTIfElseBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTIllegalStoreExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTInstanceOfExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTInvalidDependentCompilation;
import net.sourceforge.pmd.lang.apex.ast.ASTJavaMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTJavaVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralCase;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMapEntryNode;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTModifier;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierOrAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTMultiStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTNestedExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNestedStoreExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewKeyValueObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewListInitExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewListLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewMapInitExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewMapLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewSetInitExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTNewSetLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTPackageVersionExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTPostfixExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTPrefixExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTReferenceExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTRunAsBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTSoqlExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSoslExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTStandardCondition;
import net.sourceforge.pmd.lang.apex.ast.ASTStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTStatementExecuted;
import net.sourceforge.pmd.lang.apex.ast.ASTSuperMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSuperVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTTernaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTThisMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTThisVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTTriggerVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTTryCatchFinallyBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTTypeWhenBlock;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClassMethods;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTUserExceptionMethods;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTUserTrigger;
import net.sourceforge.pmd.lang.apex.ast.ASTValueWhenBlock;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclarationStatements;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTWhileLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexCommentContainerNode;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;

final class ApexTreeBuilder
extends AstVisitor<AdditionalPassScope> {
    private static final Pattern COMMENT_PATTERN = Pattern.compile("/\\*([^*]++|\\*(?!/))*+\\*/|//[^\n]++\n");
    private static final Map<Class<? extends AstNode>, Function<AstNode, ? extends AbstractApexNode<?>>> NODE_TYPE_TO_NODE_ADAPTER_TYPE = new HashMap();
    private final Deque<AbstractApexNode<?>> nodes = new ArrayDeque();
    private final Deque<AstNode> parents = new ArrayDeque<AstNode>();
    private final AdditionalPassScope scope = new AdditionalPassScope(Errors.createErrors());
    private final TextDocument sourceCode;
    private final Parser.ParserTask task;
    private final ApexLanguageProcessor proc;
    private final CommentInformation commentInfo;

    private static <T extends AstNode> void register(Class<T> nodeType, Function<T, ? extends AbstractApexNode<T>> nodeAdapterType) {
        NODE_TYPE_TO_NODE_ADAPTER_TYPE.put(nodeType, nodeAdapterType);
    }

    ApexTreeBuilder(Parser.ParserTask task, ApexLanguageProcessor proc) {
        this.sourceCode = task.getTextDocument();
        this.task = task;
        this.proc = proc;
        this.commentInfo = ApexTreeBuilder.extractInformationFromComments(this.sourceCode, ((ApexLanguageProperties)proc.getProperties()).getSuppressMarker());
    }

    static <T extends AstNode> AbstractApexNode<T> createNodeAdapter(T node) {
        Function<AstNode, AbstractApexNode<?>> constructor = NODE_TYPE_TO_NODE_ADAPTER_TYPE.get(node.getClass());
        if (constructor == null) {
            throw new IllegalStateException("There is no Node adapter class registered for the Node class: " + node.getClass());
        }
        return constructor.apply(node);
    }

    ASTApexFile buildTree(Compilation astNode) {
        assert (this.nodes.isEmpty()) : "stack should be empty";
        ASTApexFile root = new ASTApexFile(this.task, astNode, this.commentInfo.suppressMap, this.proc);
        this.nodes.push(root);
        this.parents.push((AstNode)astNode);
        this.build(astNode);
        this.nodes.pop();
        this.parents.pop();
        this.addFormalComments();
        this.closeTree(root);
        return root;
    }

    private <T extends AstNode> void build(T astNode) {
        AbstractApexCommentContainerNode commentContainer;
        AbstractApexNode<T> node = ApexTreeBuilder.createNodeAdapter(astNode);
        AbstractApexNode<?> parent = this.nodes.peek();
        parent.addChild(node, parent.getNumChildren());
        this.nodes.push(node);
        this.parents.push(astNode);
        astNode.traverse((AstVisitor)this, (Scope)this.scope);
        this.nodes.pop();
        this.parents.pop();
        if (this.nodes.isEmpty()) {
            this.addFormalComments();
        }
        if (node instanceof AbstractApexCommentContainerNode && this.containsComments(commentContainer = (AbstractApexCommentContainerNode)node)) {
            commentContainer.setContainsComment(true);
        }
    }

    private void closeTree(AbstractApexNode<?> node) {
        node.closeNode(this.sourceCode);
        for (ApexNode child : node.children()) {
            this.closeTree((AbstractApexNode)child);
        }
    }

    private boolean containsComments(ASTCommentContainer<?> commentContainer) {
        Location loc = commentContainer.getNode().getLoc();
        if (!Locations.isReal((Location)loc)) {
            return false;
        }
        List<TokenLocation> allComments = this.commentInfo.allCommentTokens;
        int index = Collections.binarySearch(this.commentInfo.allCommentTokensByStartIndex, loc.getStartIndex());
        assert (index < 0) : "comment token is at the same position as non-comment token";
        return (index ^= 0xFFFFFFFF) >= 0 && index < allComments.size() && loc.getStartIndex() < allComments.get((int)index).region.getStartOffset() && loc.getEndIndex() >= allComments.get((int)index).region.getEndOffset();
    }

    private void addFormalComments() {
        for (ApexDocTokenLocation tokenLocation : this.commentInfo.docTokenLocations) {
            AbstractApexNode parent = tokenLocation.nearestNode;
            if (parent == null) continue;
            parent.insertChild(new ASTFormalComment(tokenLocation.region, tokenLocation.image), 0);
        }
    }

    private void buildFormalComment(AstNode node) {
        if (node.equals(this.parents.peek())) {
            this.assignApexDocTokenToNode(node, this.nodes.peek());
        }
    }

    private void assignApexDocTokenToNode(AstNode jorjeNode, AbstractApexNode<?> node) {
        Location loc = jorjeNode.getLoc();
        if (!Locations.isReal((Location)loc)) {
            return;
        }
        TextRegion nodeRegion = node.getTextRegion();
        for (ApexDocTokenLocation comment : this.commentInfo.docTokenLocations) {
            if (comment.region.compareTo(nodeRegion) > 0) break;
            int distance = nodeRegion.getStartOffset() - comment.region.getStartOffset();
            if (comment.nearestNode != null && distance >= comment.nearestNodeDistance) continue;
            comment.nearestNode = node;
            comment.nearestNodeDistance = distance;
        }
    }

    private static CommentInformation extractInformationFromComments(TextDocument source, String suppressMarker) {
        Chars text = source.getText();
        boolean checkForCommentSuppression = suppressMarker != null;
        ArrayList<TokenLocation> allCommentTokens = new ArrayList<TokenLocation>();
        ArrayList<ApexDocTokenLocation> tokenLocations = new ArrayList<ApexDocTokenLocation>();
        HashMap<Integer, String> suppressMap = new HashMap<Integer, String>();
        Matcher matcher = COMMENT_PATTERN.matcher((CharSequence)text);
        while (matcher.find()) {
            Chars trimmed;
            int startIdx = matcher.start();
            int endIdx = matcher.end();
            Chars commentText = text.subSequence(startIdx, endIdx);
            TextRegion commentRegion = TextRegion.fromBothOffsets((int)startIdx, (int)endIdx);
            if (commentText.startsWith("/**")) {
                ApexDocTokenLocation doctok = new ApexDocTokenLocation(commentRegion, commentText);
                tokenLocations.add(doctok);
                continue;
            }
            TokenLocation tok = new TokenLocation(commentRegion);
            allCommentTokens.add(tok);
            if (!checkForCommentSuppression || !commentText.startsWith("//") || !(trimmed = commentText.removePrefix("//").trimStart()).startsWith(suppressMarker)) continue;
            Chars userMessage = trimmed.removePrefix(suppressMarker).trim();
            suppressMap.put(source.lineColumnAtOffset(startIdx).getLine(), userMessage.toString());
        }
        return new CommentInformation((Map<Integer, String>)suppressMap, allCommentTokens, (List<ApexDocTokenLocation>)tokenLocations);
    }

    private boolean visit(AstNode node) {
        if (node.equals(this.parents.peek())) {
            return true;
        }
        this.build(node);
        return false;
    }

    public boolean visit(UserEnum node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(UserInterface node, AdditionalPassScope scope) {
        boolean ret = this.visit((AstNode)node);
        this.buildFormalComment((AstNode)node);
        return ret;
    }

    public boolean visit(UserTrigger node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ArrayLoadExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ArrayStoreExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(AssignmentExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(BinaryExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(BooleanExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ClassRefExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(InstanceOfExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(JavaMethodCallExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(JavaVariableExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(LiteralExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ReferenceExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(MethodCallExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(NewListInitExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(NewMapInitExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(NewSetInitExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(NewListLiteralExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(NewObjectExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(NewSetLiteralExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(PackageVersionExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(PostfixExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(PrefixExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(TernaryExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(StandardCondition node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(TriggerVariableExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(VariableExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(BlockStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(BreakStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ContinueStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(DmlDeleteStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(DmlInsertStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(DmlMergeStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(DmlUndeleteStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(DmlUpdateStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(DmlUpsertStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(DoLoopStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ExpressionStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ForEachStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ForLoopStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(FieldDeclaration node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(FieldDeclarationStatements node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(IfBlockStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(IfElseBlockStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ReturnStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(RunAsBlockStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ThrowStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(VariableDeclaration node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(VariableDeclarationStatements node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(WhileLoopStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(BindExpressions node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(SoqlExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(SoslExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(NewMapLiteralExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(MapEntryNode node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(CatchBlockStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(TryCatchFinallyBlockStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(Property node, AdditionalPassScope scope) {
        boolean ret = this.visit((AstNode)node);
        this.buildFormalComment((AstNode)node);
        return ret;
    }

    public boolean visit(Field node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(Parameter node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(BridgeMethodCreator node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(UserClassMethods node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(UserExceptionMethods node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(Annotation node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(AnnotationParameter node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ModifierNode node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(SuperMethodCallExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ThisMethodCallExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(SuperVariableExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ThisVariableExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(UserClass node, AdditionalPassScope scope) {
        boolean ret = this.visit((AstNode)node);
        this.buildFormalComment((AstNode)node);
        return ret;
    }

    public boolean visit(Method node, AdditionalPassScope scope) {
        boolean ret = this.visit((AstNode)node);
        this.buildFormalComment((AstNode)node);
        return ret;
    }

    public boolean visit(AnonymousClass node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(CastExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(NewKeyValueObjectExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(SwitchStatement node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ElseWhenBlock node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(TypeWhenBlock node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(ValueWhenBlock node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(WhenCases.LiteralCase node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(WhenCases.IdentifierCase node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    public boolean visit(EmptyReferenceExpression node, AdditionalPassScope scope) {
        return this.visit((AstNode)node);
    }

    static {
        ApexTreeBuilder.register(Annotation.class, ASTAnnotation::new);
        ApexTreeBuilder.register(AnnotationParameter.class, ASTAnnotationParameter::new);
        ApexTreeBuilder.register(AnonymousClass.class, ASTAnonymousClass::new);
        ApexTreeBuilder.register(ArrayLoadExpression.class, ASTArrayLoadExpression::new);
        ApexTreeBuilder.register(ArrayStoreExpression.class, ASTArrayStoreExpression::new);
        ApexTreeBuilder.register(AssignmentExpression.class, ASTAssignmentExpression::new);
        ApexTreeBuilder.register(BinaryExpression.class, ASTBinaryExpression::new);
        ApexTreeBuilder.register(BindExpressions.class, ASTBindExpressions::new);
        ApexTreeBuilder.register(BlockStatement.class, ASTBlockStatement::new);
        ApexTreeBuilder.register(BooleanExpression.class, ASTBooleanExpression::new);
        ApexTreeBuilder.register(BreakStatement.class, ASTBreakStatement::new);
        ApexTreeBuilder.register(BridgeMethodCreator.class, ASTBridgeMethodCreator::new);
        ApexTreeBuilder.register(CastExpression.class, ASTCastExpression::new);
        ApexTreeBuilder.register(CatchBlockStatement.class, ASTCatchBlockStatement::new);
        ApexTreeBuilder.register(ClassRefExpression.class, ASTClassRefExpression::new);
        ApexTreeBuilder.register(ConstructorPreamble.class, ASTConstructorPreamble::new);
        ApexTreeBuilder.register(ConstructorPreambleStatement.class, ASTConstructorPreambleStatement::new);
        ApexTreeBuilder.register(ContinueStatement.class, ASTContinueStatement::new);
        ApexTreeBuilder.register(DmlDeleteStatement.class, ASTDmlDeleteStatement::new);
        ApexTreeBuilder.register(DmlInsertStatement.class, ASTDmlInsertStatement::new);
        ApexTreeBuilder.register(DmlMergeStatement.class, ASTDmlMergeStatement::new);
        ApexTreeBuilder.register(DmlUndeleteStatement.class, ASTDmlUndeleteStatement::new);
        ApexTreeBuilder.register(DmlUpdateStatement.class, ASTDmlUpdateStatement::new);
        ApexTreeBuilder.register(DmlUpsertStatement.class, ASTDmlUpsertStatement::new);
        ApexTreeBuilder.register(DoLoopStatement.class, ASTDoLoopStatement::new);
        ApexTreeBuilder.register(ElseWhenBlock.class, ASTElseWhenBlock::new);
        ApexTreeBuilder.register(EmptyReferenceExpression.class, ASTEmptyReferenceExpression::new);
        ApexTreeBuilder.register(Expression.class, ASTExpression::new);
        ApexTreeBuilder.register(ExpressionStatement.class, ASTExpressionStatement::new);
        ApexTreeBuilder.register(Field.class, ASTField::new);
        ApexTreeBuilder.register(FieldDeclaration.class, ASTFieldDeclaration::new);
        ApexTreeBuilder.register(FieldDeclarationStatements.class, ASTFieldDeclarationStatements::new);
        ApexTreeBuilder.register(ForEachStatement.class, ASTForEachStatement::new);
        ApexTreeBuilder.register(ForLoopStatement.class, ASTForLoopStatement::new);
        ApexTreeBuilder.register(WhenCases.IdentifierCase.class, ASTIdentifierCase::new);
        ApexTreeBuilder.register(IfBlockStatement.class, ASTIfBlockStatement::new);
        ApexTreeBuilder.register(IfElseBlockStatement.class, ASTIfElseBlockStatement::new);
        ApexTreeBuilder.register(IllegalStoreExpression.class, ASTIllegalStoreExpression::new);
        ApexTreeBuilder.register(InstanceOfExpression.class, ASTInstanceOfExpression::new);
        ApexTreeBuilder.register(InvalidDependentCompilation.class, ASTInvalidDependentCompilation::new);
        ApexTreeBuilder.register(JavaMethodCallExpression.class, ASTJavaMethodCallExpression::new);
        ApexTreeBuilder.register(JavaVariableExpression.class, ASTJavaVariableExpression::new);
        ApexTreeBuilder.register(WhenCases.LiteralCase.class, ASTLiteralCase::new);
        ApexTreeBuilder.register(LiteralExpression.class, ASTLiteralExpression::new);
        ApexTreeBuilder.register(MapEntryNode.class, ASTMapEntryNode::new);
        ApexTreeBuilder.register(Method.class, ASTMethod::new);
        ApexTreeBuilder.register(MethodBlockStatement.class, ASTMethodBlockStatement::new);
        ApexTreeBuilder.register(MethodCallExpression.class, ASTMethodCallExpression::new);
        ApexTreeBuilder.register(Modifier.class, ASTModifier::new);
        ApexTreeBuilder.register(ModifierNode.class, ASTModifierNode::new);
        ApexTreeBuilder.register(ModifierOrAnnotation.class, ASTModifierOrAnnotation::new);
        ApexTreeBuilder.register(MultiStatement.class, ASTMultiStatement::new);
        ApexTreeBuilder.register(NestedExpression.class, ASTNestedExpression::new);
        ApexTreeBuilder.register(NestedStoreExpression.class, ASTNestedStoreExpression::new);
        ApexTreeBuilder.register(NewKeyValueObjectExpression.class, ASTNewKeyValueObjectExpression::new);
        ApexTreeBuilder.register(NewListInitExpression.class, ASTNewListInitExpression::new);
        ApexTreeBuilder.register(NewListLiteralExpression.class, ASTNewListLiteralExpression::new);
        ApexTreeBuilder.register(NewMapInitExpression.class, ASTNewMapInitExpression::new);
        ApexTreeBuilder.register(NewMapLiteralExpression.class, ASTNewMapLiteralExpression::new);
        ApexTreeBuilder.register(NewObjectExpression.class, ASTNewObjectExpression::new);
        ApexTreeBuilder.register(NewSetInitExpression.class, ASTNewSetInitExpression::new);
        ApexTreeBuilder.register(NewSetLiteralExpression.class, ASTNewSetLiteralExpression::new);
        ApexTreeBuilder.register(PackageVersionExpression.class, ASTPackageVersionExpression::new);
        ApexTreeBuilder.register(Parameter.class, ASTParameter::new);
        ApexTreeBuilder.register(PostfixExpression.class, ASTPostfixExpression::new);
        ApexTreeBuilder.register(PrefixExpression.class, ASTPrefixExpression::new);
        ApexTreeBuilder.register(Property.class, ASTProperty::new);
        ApexTreeBuilder.register(ReferenceExpression.class, ASTReferenceExpression::new);
        ApexTreeBuilder.register(ReturnStatement.class, ASTReturnStatement::new);
        ApexTreeBuilder.register(RunAsBlockStatement.class, ASTRunAsBlockStatement::new);
        ApexTreeBuilder.register(SoqlExpression.class, ASTSoqlExpression::new);
        ApexTreeBuilder.register(SoslExpression.class, ASTSoslExpression::new);
        ApexTreeBuilder.register(StandardCondition.class, ASTStandardCondition::new);
        ApexTreeBuilder.register(Statement.class, ASTStatement::new);
        ApexTreeBuilder.register(StatementExecuted.class, ASTStatementExecuted::new);
        ApexTreeBuilder.register(SuperMethodCallExpression.class, ASTSuperMethodCallExpression::new);
        ApexTreeBuilder.register(SuperVariableExpression.class, ASTSuperVariableExpression::new);
        ApexTreeBuilder.register(SwitchStatement.class, ASTSwitchStatement::new);
        ApexTreeBuilder.register(TernaryExpression.class, ASTTernaryExpression::new);
        ApexTreeBuilder.register(ThisMethodCallExpression.class, ASTThisMethodCallExpression::new);
        ApexTreeBuilder.register(ThisVariableExpression.class, ASTThisVariableExpression::new);
        ApexTreeBuilder.register(ThrowStatement.class, ASTThrowStatement::new);
        ApexTreeBuilder.register(TriggerVariableExpression.class, ASTTriggerVariableExpression::new);
        ApexTreeBuilder.register(TryCatchFinallyBlockStatement.class, ASTTryCatchFinallyBlockStatement::new);
        ApexTreeBuilder.register(TypeWhenBlock.class, ASTTypeWhenBlock::new);
        ApexTreeBuilder.register(UserClass.class, ASTUserClass::new);
        ApexTreeBuilder.register(UserClassMethods.class, ASTUserClassMethods::new);
        ApexTreeBuilder.register(UserExceptionMethods.class, ASTUserExceptionMethods::new);
        ApexTreeBuilder.register(UserEnum.class, ASTUserEnum::new);
        ApexTreeBuilder.register(UserInterface.class, ASTUserInterface::new);
        ApexTreeBuilder.register(UserTrigger.class, ASTUserTrigger::new);
        ApexTreeBuilder.register(ValueWhenBlock.class, ASTValueWhenBlock::new);
        ApexTreeBuilder.register(VariableDeclaration.class, ASTVariableDeclaration::new);
        ApexTreeBuilder.register(VariableDeclarationStatements.class, ASTVariableDeclarationStatements::new);
        ApexTreeBuilder.register(VariableExpression.class, ASTVariableExpression::new);
        ApexTreeBuilder.register(WhileLoopStatement.class, ASTWhileLoopStatement::new);
    }

    private static class ApexDocTokenLocation
    extends TokenLocation {
        private final Chars image;
        private AbstractApexNode<?> nearestNode;
        private int nearestNodeDistance;

        ApexDocTokenLocation(TextRegion commentRegion, Chars image) {
            super(commentRegion);
            this.image = image;
        }
    }

    private static class TokenLocation {
        final TextRegion region;

        TokenLocation(TextRegion region) {
            this.region = region;
        }
    }

    private static final class TokenListByStartIndex
    extends AbstractList<Integer>
    implements RandomAccess {
        private final List<TokenLocation> tokens;

        <T extends List<TokenLocation> & RandomAccess> TokenListByStartIndex(T tokens) {
            this.tokens = tokens;
        }

        @Override
        public Integer get(int index) {
            return this.tokens.get((int)index).region.getStartOffset();
        }

        @Override
        public int size() {
            return this.tokens.size();
        }
    }

    private static class CommentInformation {
        final Map<Integer, String> suppressMap;
        final List<TokenLocation> allCommentTokens;
        final TokenListByStartIndex allCommentTokensByStartIndex;
        final List<ApexDocTokenLocation> docTokenLocations;

        <T extends List<TokenLocation> & RandomAccess> CommentInformation(Map<Integer, String> suppressMap, T allCommentTokens, List<ApexDocTokenLocation> docTokenLocations) {
            this.suppressMap = suppressMap;
            this.allCommentTokens = allCommentTokens;
            this.docTokenLocations = docTokenLocations;
            this.allCommentTokensByStartIndex = new TokenListByStartIndex(allCommentTokens);
        }
    }
}

