/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.metrics;

import java.util.function.Function;
import java.util.function.Predicate;
import net.sourceforge.pmd.internal.util.PredicateUtil;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClassOrInterface;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.metrics.internal.CognitiveComplexityVisitor;
import net.sourceforge.pmd.lang.apex.metrics.internal.StandardCycloVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import org.apache.commons.lang3.mutable.MutableInt;

public final class ApexMetrics {
    private static final Class<ApexNode<?>> GENERIC_APEX_NODE_CLASS = ApexNode.class;
    public static final Metric<ApexNode<?>, Integer> CYCLO = Metric.of(ApexMetrics::computeCyclo, ApexMetrics.isRegularApexNode(), (String)"Cyclomatic Complexity", (String[])new String[]{"Cyclo"});
    public static final Metric<ApexNode<?>, Integer> COGNITIVE_COMPLEXITY = Metric.of(ApexMetrics::computeCognitiveComp, ApexMetrics.isRegularApexNode(), (String)"Cognitive Complexity", (String[])new String[0]);
    public static final Metric<ASTUserClassOrInterface<?>, Integer> WEIGHED_METHOD_COUNT = Metric.of(ApexMetrics::computeWmc, ApexMetrics.filterMapNode(ASTUserClass.class, PredicateUtil.always()), (String)"Weighed Method Count", (String[])new String[]{"WMC"});

    private ApexMetrics() {
    }

    private static Function<Node, ApexNode<?>> isRegularApexNode() {
        return ApexMetrics.filterMapNode(GENERIC_APEX_NODE_CLASS, n -> !(n instanceof ASTMethod) || !((ASTMethod)n).isSynthetic());
    }

    private static <T extends Node> Function<Node, T> filterMapNode(Class<? extends T> klass, Predicate<? super T> pred) {
        return n -> n.asStream().filterIs(klass).filter(pred).first();
    }

    private static int computeCyclo(ApexNode<?> node, MetricOptions ignored) {
        MutableInt result = new MutableInt(1);
        node.acceptVisitor(new StandardCycloVisitor(), result);
        return result.getValue();
    }

    private static int computeCognitiveComp(ApexNode<?> node, MetricOptions ignored) {
        CognitiveComplexityVisitor.State state = new CognitiveComplexityVisitor.State();
        node.acceptVisitor(CognitiveComplexityVisitor.INSTANCE, state);
        return state.getComplexity();
    }

    private static int computeWmc(ASTUserClassOrInterface<?> node, MetricOptions options) {
        return (int)MetricsUtil.computeStatistics(CYCLO, node.getMethods(), (MetricOptions)options).getSum();
    }
}

