/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.codestyle;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.rule.codestyle.AbstractNamingConventionsRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FieldNamingConventionsRule
extends AbstractNamingConventionsRule {
    private static final Map<String, String> DESCRIPTOR_TO_DISPLAY_NAME = new HashMap<String, String>();
    private static final PropertyDescriptor<Pattern> ENUM_CONSTANT_REGEX = ((PropertyBuilder.RegexPropertyBuilder)FieldNamingConventionsRule.prop("enumConstantPattern", "enum constant field", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)ALL_CAPS)).build();
    private static final PropertyDescriptor<Pattern> CONSTANT_REGEX = ((PropertyBuilder.RegexPropertyBuilder)FieldNamingConventionsRule.prop("constantPattern", "constant field", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)ALL_CAPS)).build();
    private static final PropertyDescriptor<Pattern> FINAL_REGEX = ((PropertyBuilder.RegexPropertyBuilder)FieldNamingConventionsRule.prop("finalPattern", "final field", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();
    private static final PropertyDescriptor<Pattern> STATIC_REGEX = ((PropertyBuilder.RegexPropertyBuilder)FieldNamingConventionsRule.prop("staticPattern", "static field", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();
    private static final PropertyDescriptor<Pattern> INSTANCE_REGEX = ((PropertyBuilder.RegexPropertyBuilder)FieldNamingConventionsRule.prop("instancePattern", "instance field", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();

    public FieldNamingConventionsRule() {
        this.definePropertyDescriptor(ENUM_CONSTANT_REGEX);
        this.definePropertyDescriptor(CONSTANT_REGEX);
        this.definePropertyDescriptor(FINAL_REGEX);
        this.definePropertyDescriptor(STATIC_REGEX);
        this.definePropertyDescriptor(INSTANCE_REGEX);
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTField.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTField node, Object data) {
        if (node.getFirstParentOfType(ASTProperty.class) != null) {
            return data;
        }
        ASTModifierNode modifiers = node.getModifiers();
        if (node.getFirstParentOfType(ASTUserEnum.class) != null) {
            this.checkMatches(ENUM_CONSTANT_REGEX, node, data);
        } else if (modifiers.isFinal() && modifiers.isStatic()) {
            this.checkMatches(CONSTANT_REGEX, node, data);
        } else if (modifiers.isFinal()) {
            this.checkMatches(FINAL_REGEX, node, data);
        } else if (modifiers.isStatic()) {
            this.checkMatches(STATIC_REGEX, node, data);
        } else {
            this.checkMatches(INSTANCE_REGEX, node, data);
        }
        return data;
    }

    @Override
    protected String displayName(String name) {
        return DESCRIPTOR_TO_DISPLAY_NAME.get(name);
    }
}

