/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import java.util.ArrayDeque;
import java.util.Deque;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.apex.ast.ASTBooleanExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTDoLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForEachStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTIfBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTTernaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTTryCatchFinallyBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTUserTrigger;
import net.sourceforge.pmd.lang.apex.ast.ASTWhileLoopStatement;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class StdCyclomaticComplexityRule
extends AbstractApexRule {
    public static final PropertyDescriptor<Integer> REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"reportLevel").desc("Cyclomatic Complexity reporting threshold")).require(NumericConstraints.inRange((Number)1, (Number)30))).defaultValue((Object)10)).build();
    public static final PropertyDescriptor<Boolean> SHOW_CLASSES_COMPLEXITY_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"showClassesComplexity").desc("Add class average violations to the report")).defaultValue((Object)true)).build();
    public static final PropertyDescriptor<Boolean> SHOW_METHODS_COMPLEXITY_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"showMethodsComplexity").desc("Add method average violations to the report")).defaultValue((Object)true)).build();
    private int reportLevel;
    private boolean showClassesComplexity = true;
    private boolean showMethodsComplexity = true;
    protected Deque<Entry> entryStack = new ArrayDeque<Entry>();

    public StdCyclomaticComplexityRule() {
        this.definePropertyDescriptor(REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.definePropertyDescriptor(SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
    }

    public void start(RuleContext ctx) {
        this.reportLevel = (Integer)this.getProperty(REPORT_LEVEL_DESCRIPTOR);
        this.showClassesComplexity = (Boolean)this.getProperty(SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.showMethodsComplexity = (Boolean)this.getProperty(SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        this.entryStack.push(new Entry());
        super.visit(node, data);
        Entry classEntry = this.entryStack.pop();
        if (this.showClassesComplexity && (classEntry.getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel)) {
            this.addViolation(data, (Node)node, new String[]{"class", node.getImage(), classEntry.getComplexityAverage() + " (Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    @Override
    public Object visit(ASTUserTrigger node, Object data) {
        this.entryStack.push(new Entry());
        super.visit(node, data);
        Entry classEntry = this.entryStack.pop();
        if (this.showClassesComplexity && (classEntry.getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel)) {
            this.addViolation(data, (Node)node, new String[]{"trigger", node.getImage(), classEntry.getComplexityAverage() + " (Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    @Override
    public Object visit(ASTUserInterface node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTUserEnum node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (!node.isSynthetic()) {
            this.entryStack.push(new Entry());
            super.visit(node, data);
            Entry methodEntry = this.entryStack.pop();
            int methodDecisionPoints = methodEntry.decisionPoints;
            Entry classEntry = this.entryStack.peek();
            ++classEntry.methodCount;
            classEntry.bumpDecisionPoints(methodDecisionPoints);
            if (methodDecisionPoints > classEntry.highestDecisionPoints) {
                classEntry.highestDecisionPoints = methodDecisionPoints;
            }
            if (this.showMethodsComplexity && methodEntry.decisionPoints >= this.reportLevel) {
                String methodType = node.isConstructor() ? "constructor" : "method";
                this.addViolation(data, (Node)node, new String[]{methodType, node.getImage(), String.valueOf(methodEntry.decisionPoints)});
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTIfBlockStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTTryCatchFinallyBlockStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTForLoopStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTForEachStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTWhileLoopStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTDoLoopStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTTernaryExpression node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTBooleanExpression node, Object data) {
        return data;
    }

    protected static final class Entry {
        private int decisionPoints = 1;
        public int highestDecisionPoints;
        public int methodCount;

        private Entry() {
        }

        public void bumpDecisionPoints() {
            ++this.decisionPoints;
        }

        public void bumpDecisionPoints(int size) {
            this.decisionPoints += size;
        }

        public int getComplexityAverage() {
            return (double)this.methodCount == 0.0 ? 1 : (int)Math.rint((double)this.decisionPoints / (double)this.methodCount);
        }
    }
}

