/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;

public class InaccessibleAuraEnabledGetterRule
extends AbstractApexRule {
    public InaccessibleAuraEnabledGetterRule() {
        this.addRuleChainVisit(ASTProperty.class);
    }

    @Override
    public Object visit(ASTProperty node, Object data) {
        ASTModifierNode propModifiers = node.getModifiers();
        if (this.hasAuraEnabledAnnotation(propModifiers)) {
            List methods = node.findChildrenOfType(ASTMethod.class);
            for (ASTMethod method : methods) {
                ASTModifierNode methodModifiers;
                if ("void".equals(method.getReturnType()) || !this.isPrivate(methodModifiers = method.getModifiers()) && !this.isProtected(methodModifiers)) continue;
                this.addViolation(data, (Node)node);
            }
        }
        return data;
    }

    private boolean isPrivate(ASTModifierNode modifierNode) {
        return modifierNode != null && modifierNode.isPrivate();
    }

    private boolean isProtected(ASTModifierNode modifierNode) {
        return modifierNode != null && modifierNode.isProtected();
    }

    private boolean hasAuraEnabledAnnotation(ASTModifierNode modifierNode) {
        List annotations = modifierNode.findChildrenOfType(ASTAnnotation.class);
        for (ASTAnnotation annotation : annotations) {
            if (!annotation.hasImageEqualTo("AuraEnabled")) continue;
            return true;
        }
        return false;
    }
}

