/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApexDangerousMethodsRule
extends AbstractApexRule {
    private static final String BOOLEAN = "boolean";
    private static final Pattern REGEXP = Pattern.compile("^.*?(pass|pwd|crypt|auth|session|token|saml)(?!id|user).*?$", 2);
    private static final String DISABLE_CRUD = "disableTriggerCRUDSecurity";
    private static final String CONFIGURATION = "Configuration";
    private static final String SYSTEM = "System";
    private static final String DEBUG = "debug";
    private final Set<String> whiteListedVariables = new HashSet<String>();

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node)) {
            return data;
        }
        this.collectBenignVariables(node);
        List methodCalls = node.findDescendantsOfType(ASTMethodCallExpression.class);
        for (ASTMethodCallExpression methodCall : methodCalls) {
            if (Helper.isMethodName(methodCall, CONFIGURATION, DISABLE_CRUD)) {
                this.addViolation(data, (Node)methodCall);
            }
            if (!Helper.isMethodName(methodCall, SYSTEM, DEBUG)) continue;
            this.validateParameters(methodCall, data);
        }
        this.whiteListedVariables.clear();
        return data;
    }

    private void collectBenignVariables(ASTUserClass node) {
        List fields = node.findDescendantsOfType(ASTField.class);
        for (ASTField field : fields) {
            if (!BOOLEAN.equalsIgnoreCase(field.getType())) continue;
            this.whiteListedVariables.add(Helper.getFQVariableName(field));
        }
        List declarations = node.findDescendantsOfType(ASTVariableDeclaration.class);
        for (ASTVariableDeclaration decl : declarations) {
            if (!BOOLEAN.equalsIgnoreCase(decl.getType())) continue;
            this.whiteListedVariables.add(Helper.getFQVariableName(decl));
        }
    }

    private void validateParameters(ASTMethodCallExpression methodCall, Object data) {
        List variables = methodCall.findDescendantsOfType(ASTVariableExpression.class);
        for (ASTVariableExpression var : variables) {
            if (!REGEXP.matcher(var.getImage()).matches() || this.whiteListedVariables.contains(Helper.getFQVariableName(var))) continue;
            this.addViolation(data, (Node)methodCall);
        }
    }
}

