/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import apex.jorje.parser.impl.ApexLexer;
import java.util.Locale;
import java.util.Properties;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.apex.ApexJorjeLogging;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import net.sourceforge.pmd.lang.document.FileId;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;

public class ApexTokenizer
implements Tokenizer {
    public static final String CASE_SENSITIVE = "net.sourceforge.pmd.cpd.ApexTokenizer.caseSensitive";
    private boolean caseSensitive;

    public ApexTokenizer() {
        ApexJorjeLogging.disableLogging();
    }

    public void setProperties(Properties properties) {
        this.caseSensitive = Boolean.parseBoolean(properties.getProperty(CASE_SENSITIVE, "false"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder code = sourceCode.getCodeBuffer();
        ANTLRStringStream ass = new ANTLRStringStream(code.toString());
        ApexLexer lexer = new ApexLexer((CharStream)ass){

            public void emitErrorMessage(String msg) {
                throw new TokenMgrError(this.getLine(), this.getCharPositionInLine(), FileId.fromPathLikeString((String)this.getSourceName()), msg, null);
            }
        };
        try {
            Token token = lexer.nextToken();
            while (token.getType() != -1) {
                if (token.getChannel() != 99) {
                    String tokenText = token.getText();
                    if (!this.caseSensitive) {
                        tokenText = tokenText.toLowerCase(Locale.ROOT);
                    }
                    TokenEntry tokenEntry = new TokenEntry(tokenText, sourceCode.getFileName(), token.getLine(), token.getCharPositionInLine() + 1, token.getCharPositionInLine() + tokenText.length() + 1);
                    tokenEntries.add(tokenEntry);
                }
                token = lexer.nextToken();
            }
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }
}

