/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.Identifier;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import java.util.Optional;
import net.sourceforge.pmd.lang.apex.ast.ASTNewKeyValueObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class ASTLiteralExpression
extends AbstractApexNode<LiteralExpression> {
    ASTLiteralExpression(LiteralExpression literalExpression) {
        super(literalExpression);
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public LiteralType getLiteralType() {
        return ((LiteralExpression)this.node).getLiteralType();
    }

    public boolean isString() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.STRING;
    }

    public boolean isBoolean() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.TRUE || ((LiteralExpression)this.node).getLiteralType() == LiteralType.FALSE;
    }

    public boolean isInteger() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.INTEGER;
    }

    public boolean isDouble() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.DOUBLE;
    }

    public boolean isLong() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.LONG;
    }

    public boolean isDecimal() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.DECIMAL;
    }

    public boolean isNull() {
        return ((LiteralExpression)this.node).getLiteralType() == LiteralType.NULL;
    }

    public String getImage() {
        if (((LiteralExpression)this.node).getLiteral() != null) {
            return String.valueOf(((LiteralExpression)this.node).getLiteral());
        }
        return null;
    }

    public String getName() {
        if (this.getParent() instanceof ASTNewKeyValueObjectExpression) {
            ASTNewKeyValueObjectExpression parent = (ASTNewKeyValueObjectExpression)this.getParent();
            Optional<NewKeyValueObjectExpression.NameValueParameter> parameter = ((NewKeyValueObjectExpression)parent.node).getParameters().stream().filter(p -> {
                try {
                    return ((LiteralExpression)this.node).equals(FieldUtils.readDeclaredField((Object)p, (String)"expression", (boolean)true));
                }
                catch (IllegalArgumentException | ReflectiveOperationException e) {
                    return false;
                }
            }).findFirst();
            return parameter.map(p -> {
                try {
                    return (Identifier)FieldUtils.readDeclaredField((Object)p, (String)"name", (boolean)true);
                }
                catch (IllegalArgumentException | ReflectiveOperationException e) {
                    return null;
                }
            }).map(Identifier::getValue).orElse(null);
        }
        return null;
    }
}

