/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.TypeInfo;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.apex.ast.ASTApexFile;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.AbstractNode;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class AbstractApexNode<T extends AstNode>
extends AbstractNode<AbstractApexNode<?>, ApexNode<?>>
implements ApexNode<T> {
    protected final T node;
    private TextRegion region;

    protected AbstractApexNode(T node) {
        this.node = node;
    }

    protected void addChild(AbstractApexNode<?> child, int index) {
        super.addChild(child, index);
    }

    protected void insertChild(AbstractApexNode<?> child, int index) {
        super.insertChild(child, index);
    }

    public final <P, R> R acceptVisitor(AstVisitor<? super P, ? extends R> visitor, P data) {
        if (visitor instanceof ApexVisitor) {
            return this.acceptApexVisitor((ApexVisitor)visitor, data);
        }
        return (R)visitor.cannotVisit((Node)this, data);
    }

    protected abstract <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> var1, P var2);

    @Override
    public @NonNull ASTApexFile getRoot() {
        return ((ApexNode)this.getParent()).getRoot();
    }

    public @NonNull TextRegion getTextRegion() {
        if (this.region == null) {
            if (!this.hasRealLoc()) {
                AbstractApexNode parent = (AbstractApexNode)this.getParent();
                if (parent == null) {
                    throw new FileAnalysisException("Unable to determine location of " + this);
                }
                this.region = parent.getTextRegion();
            } else {
                Location loc = this.node.getLoc();
                this.region = TextRegion.fromBothOffsets((int)loc.getStartIndex(), (int)loc.getEndIndex());
            }
        }
        return this.region;
    }

    public final String getXPathNodeName() {
        return this.getClass().getSimpleName().replaceFirst("^AST", "");
    }

    void closeNode(TextDocument positioner) {
    }

    protected void setRegion(TextRegion region) {
        this.region = region;
    }

    @Override
    @Deprecated
    @InternalApi
    public T getNode() {
        return this.node;
    }

    @Override
    public boolean hasRealLoc() {
        try {
            Location loc = this.node.getLoc();
            return loc != null && Locations.isReal((Location)loc);
        }
        catch (UnexpectedCodePathException e) {
            return false;
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            return false;
        }
    }

    private TypeInfo getDefiningTypeOrNull() {
        try {
            return this.node.getDefiningType();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public String getDefiningType() {
        TypeInfo definingType = this.getDefiningTypeOrNull();
        if (definingType != null) {
            return definingType.getApexName();
        }
        return null;
    }

    @Override
    public String getNamespace() {
        TypeInfo definingType = this.getDefiningTypeOrNull();
        if (definingType != null) {
            return definingType.getNamespace().toString();
        }
        return null;
    }
}

