/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.CompilerStage;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.NoopCompilerProgressCallback;
import apex.jorje.semantic.compiler.sfdc.QueryValidator;
import apex.jorje.semantic.compiler.sfdc.SymbolProvider;
import apex.jorje.services.exception.CompilationException;
import apex.jorje.services.exception.ParseException;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.EmptySymbolProvider;
import net.sourceforge.pmd.lang.apex.ast.TestAccessEvaluator;
import net.sourceforge.pmd.lang.apex.ast.TestQueryValidators;
import net.sourceforge.pmd.lang.document.TextDocument;

class CompilerService {
    public static final CompilerService INSTANCE = new CompilerService();
    private final SymbolProvider symbolProvider;
    private final AccessEvaluator accessEvaluator;
    private final QueryValidator queryValidator;

    CompilerService() {
        this(EmptySymbolProvider.get(), new TestAccessEvaluator(), new TestQueryValidators.Noop());
    }

    CompilerService(SymbolProvider symbolProvider, AccessEvaluator accessEvaluator, QueryValidator queryValidator) {
        this.symbolProvider = symbolProvider;
        this.accessEvaluator = accessEvaluator;
        this.queryValidator = queryValidator;
    }

    public Compilation parseApex(TextDocument document) {
        SourceFile sourceFile = SourceFile.builder().setBody(document.getText().toString()).setKnownName(document.getFileId().getUriString()).build();
        ApexCompiler compiler = ApexCompiler.builder().setInput(this.createCompilationInput(Collections.singletonList(sourceFile))).build();
        compiler.compile(CompilerStage.POST_TYPE_RESOLVE);
        this.throwParseErrorIfAny(compiler);
        return ((CodeUnit)compiler.getCodeUnits().get(0)).getNode();
    }

    private void throwParseErrorIfAny(ApexCompiler compiler) {
        ParseException parseError = null;
        for (CompilationException error : compiler.getErrors()) {
            if (!(error instanceof ParseException)) continue;
            if (parseError == null) {
                parseError = (ParseException)error;
                continue;
            }
            parseError.addSuppressed((Throwable)error);
        }
        if (parseError != null) {
            throw parseError;
        }
    }

    private CompilationInput createCompilationInput(List<SourceFile> sourceFiles) {
        return new CompilationInput(sourceFiles, this.symbolProvider, this.accessEvaluator, this.queryValidator, null, NoopCompilerProgressCallback.get());
    }
}

