/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.multifile;

import com.nawforce.common.api.FileIssueOptions;
import com.nawforce.common.api.Org;
import com.nawforce.common.api.ServerOps;
import com.nawforce.common.diagnostics.Issue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.apex.ApexLanguageProperties;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public final class ApexMultifileAnalysis {
    static final Logger LOG = LoggerFactory.getLogger(ApexMultifileAnalysis.class);
    private static final int MAX_ERRORS_PER_FILE = 100;
    private final @Nullable Org org;
    private final FileIssueOptions options = ApexMultifileAnalysis.makeOptions();

    @InternalApi
    public ApexMultifileAnalysis(ApexLanguageProperties properties) {
        Org org;
        String rootDir = (String)properties.getProperty(ApexLanguageProperties.MULTIFILE_DIRECTORY);
        LOG.debug("MultiFile Analysis created for {}", (Object)rootDir);
        try {
            org = Org.newOrg();
            if (rootDir != null && !rootDir.isEmpty()) {
                org.newSFDXPackage(rootDir);
                org.flush();
            }
        }
        catch (Exception | ExceptionInInitializerError | NoClassDefFoundError e) {
            LOG.error("Exception while initializing Apexlink ({})", (Object)e.getMessage(), (Object)e);
            LOG.error("PMD will not attempt to initialize Apexlink further, this can cause rules like UnusedMethod to be dysfunctional");
            org = null;
        }
        this.org = org;
    }

    private static FileIssueOptions makeOptions() {
        FileIssueOptions options = new FileIssueOptions();
        options.includeZombies_$eq(true);
        options.maxErrorsPerFile_$eq(Integer.valueOf(100));
        return options;
    }

    public boolean isFailed() {
        return this.org == null;
    }

    public List<Issue> getFileIssues(String filename) {
        return this.org == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(this.org.getFileIssues(filename, this.options)));
    }

    static {
        ServerOps.setAutoFlush((boolean)false);
        ServerOps.setLogger((com.nawforce.common.api.Logger)new AnalysisLogger());
        ServerOps.setDebugLogging((String[])new String[]{"ALL"});
    }

    private static final class AnalysisLogger
    implements com.nawforce.common.api.Logger {
        private AnalysisLogger() {
        }

        public void error(String message) {
            LOG.error(message);
        }

        public void info(String message) {
            LOG.info(message);
        }

        public void debug(String message) {
            LOG.debug(message);
        }
    }
}

