/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.bestpractices;

import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotationParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexUnitTestRule;
import net.sourceforge.pmd.lang.ast.Node;

public class ApexUnitTestShouldNotUseSeeAllDataTrueRule
extends AbstractApexUnitTestRule {
    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (!this.isTestMethodOrClass(node)) {
            return data;
        }
        this.checkForSeeAllData(node, data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (!this.isTestMethodOrClass(node)) {
            return data;
        }
        return this.checkForSeeAllData(node, data);
    }

    private Object checkForSeeAllData(ApexNode<?> node, Object data) {
        ASTModifierNode modifierNode = (ASTModifierNode)node.getFirstChildOfType(ASTModifierNode.class);
        if (modifierNode != null) {
            List annotationParameters = modifierNode.findDescendantsOfType(ASTAnnotationParameter.class);
            for (ASTAnnotationParameter parameter : annotationParameters) {
                if (!"seeAllData".equals(parameter.getName()) || !parameter.getBooleanValue().booleanValue()) continue;
                this.addViolation(data, (Node)node);
                return data;
            }
        }
        return data;
    }
}

