/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.bestpractices;

import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;

public class AvoidGlobalModifierRule
extends AbstractApexRule {
    @Override
    public Object visit(ASTUserClass node, Object data) {
        return this.checkForGlobal(node, data);
    }

    @Override
    public Object visit(ASTUserInterface node, Object data) {
        return this.checkForGlobal(node, data);
    }

    private Object checkForGlobal(ApexNode<?> node, Object data) {
        ASTModifierNode modifierNode = (ASTModifierNode)node.getFirstChildOfType(ASTModifierNode.class);
        if (this.isGlobal(modifierNode) && !this.hasRestAnnotation(modifierNode) && !this.hasWebServices(node)) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private boolean hasWebServices(ApexNode<?> node) {
        List methods = node.findChildrenOfType(ASTMethod.class);
        for (ASTMethod method : methods) {
            ASTModifierNode methodModifier = (ASTModifierNode)method.getFirstChildOfType(ASTModifierNode.class);
            if (!this.isWebService(methodModifier)) continue;
            return true;
        }
        return false;
    }

    private boolean isWebService(ASTModifierNode modifierNode) {
        return modifierNode != null && modifierNode.isWebService();
    }

    private boolean isGlobal(ASTModifierNode modifierNode) {
        return modifierNode != null && modifierNode.isGlobal();
    }

    private boolean hasRestAnnotation(ASTModifierNode modifierNode) {
        List annotations = modifierNode.findChildrenOfType(ASTAnnotation.class);
        for (ASTAnnotation annotation : annotations) {
            if (!annotation.hasImageEqualTo("RestResource")) continue;
            return true;
        }
        return false;
    }
}

