/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.codestyle;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.rule.codestyle.AbstractNamingConventionsRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ClassNamingConventionsRule
extends AbstractNamingConventionsRule {
    private static final Map<String, String> DESCRIPTOR_TO_DISPLAY_NAME = new HashMap<String, String>();
    private static final PropertyDescriptor<Pattern> TEST_CLASS_REGEX = ((PropertyBuilder.RegexPropertyBuilder)ClassNamingConventionsRule.prop("testClassPattern", "test class", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)PASCAL_CASE_WITH_UNDERSCORES)).build();
    private static final PropertyDescriptor<Pattern> ABSTRACT_CLASS_REGEX = ((PropertyBuilder.RegexPropertyBuilder)ClassNamingConventionsRule.prop("abstractClassPattern", "abstract class", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)PASCAL_CASE_WITH_UNDERSCORES)).build();
    private static final PropertyDescriptor<Pattern> CLASS_REGEX = ((PropertyBuilder.RegexPropertyBuilder)ClassNamingConventionsRule.prop("classPattern", "class", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)PASCAL_CASE_WITH_UNDERSCORES)).build();
    private static final PropertyDescriptor<Pattern> INTERFACE_REGEX = ((PropertyBuilder.RegexPropertyBuilder)ClassNamingConventionsRule.prop("interfacePattern", "interface", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)PASCAL_CASE_WITH_UNDERSCORES)).build();
    private static final PropertyDescriptor<Pattern> ENUM_REGEX = ((PropertyBuilder.RegexPropertyBuilder)ClassNamingConventionsRule.prop("enumPattern", "enum", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)PASCAL_CASE_WITH_UNDERSCORES)).build();

    public ClassNamingConventionsRule() {
        this.definePropertyDescriptor(TEST_CLASS_REGEX);
        this.definePropertyDescriptor(ABSTRACT_CLASS_REGEX);
        this.definePropertyDescriptor(CLASS_REGEX);
        this.definePropertyDescriptor(INTERFACE_REGEX);
        this.definePropertyDescriptor(ENUM_REGEX);
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[]{ASTUserInterface.class, ASTUserEnum.class});
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (node.getModifiers().isTest()) {
            this.checkMatches(TEST_CLASS_REGEX, node, data);
        } else if (node.getModifiers().isAbstract()) {
            this.checkMatches(ABSTRACT_CLASS_REGEX, node, data);
        } else {
            this.checkMatches(CLASS_REGEX, node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTUserInterface node, Object data) {
        this.checkMatches(INTERFACE_REGEX, node, data);
        return data;
    }

    @Override
    public Object visit(ASTUserEnum node, Object data) {
        this.checkMatches(ENUM_REGEX, node, data);
        return data;
    }

    @Override
    protected String displayName(String name) {
        return DESCRIPTOR_TO_DISPLAY_NAME.get(name);
    }
}

