/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import java.util.ArrayDeque;
import java.util.Deque;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserTrigger;
import net.sourceforge.pmd.lang.apex.metrics.ApexMetrics;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class CognitiveComplexityRule
extends AbstractApexRule {
    private static final PropertyDescriptor<Integer> CLASS_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"classReportLevel").desc("Total class cognitive complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)50)).build();
    private static final PropertyDescriptor<Integer> METHOD_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"methodReportLevel").desc("Cognitive complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)15)).build();
    private Deque<String> classNames = new ArrayDeque<String>();
    private boolean inTrigger;

    public CognitiveComplexityRule() {
        this.definePropertyDescriptor(CLASS_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(METHOD_LEVEL_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTUserTrigger node, Object data) {
        this.inTrigger = true;
        super.visit(node, data);
        this.inTrigger = false;
        return data;
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        Integer classLevelThreshold;
        int classCognitive;
        this.classNames.push(node.getImage());
        super.visit(node, data);
        this.classNames.pop();
        if (ApexMetrics.COGNITIVE_COMPLEXITY.supports((Node)node) && (classCognitive = ((Integer)MetricsUtil.computeMetric(ApexMetrics.COGNITIVE_COMPLEXITY, (Node)node)).intValue()) >= (classLevelThreshold = (Integer)this.getProperty(CLASS_LEVEL_DESCRIPTOR))) {
            int classHighest = (int)MetricsUtil.computeStatistics(ApexMetrics.COGNITIVE_COMPLEXITY, (Iterable)node.getMethods()).getMax();
            Object[] messageParams = new String[]{"class", node.getImage(), " total", classCognitive + " (highest " + classHighest + ")", String.valueOf(classLevelThreshold)};
            this.addViolation(data, (Node)node, messageParams);
        }
        return data;
    }

    @Override
    public final Object visit(ASTMethod node, Object data) {
        Integer methodLevelThreshold;
        int cognitive;
        if (ApexMetrics.COGNITIVE_COMPLEXITY.supports((Node)node) && (cognitive = ((Integer)MetricsUtil.computeMetric(ApexMetrics.COGNITIVE_COMPLEXITY, (Node)node)).intValue()) >= (methodLevelThreshold = (Integer)this.getProperty(METHOD_LEVEL_DESCRIPTOR))) {
            String opType = this.inTrigger ? "trigger" : (node.getImage().equals(this.classNames.peek()) ? "constructor" : "method");
            this.addViolation(data, (Node)node, new String[]{opType, node.getQualifiedName().getOperation(), "", "" + cognitive, String.valueOf(methodLevelThreshold)});
        }
        return data;
    }
}

