/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclarationStatements;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.internal.AbstractCounterCheckRule;

public class ExcessivePublicCountRule
extends AbstractCounterCheckRule<ASTUserClass> {
    public ExcessivePublicCountRule() {
        super(ASTUserClass.class);
    }

    @Override
    protected int defaultReportLevel() {
        return 20;
    }

    @Override
    protected int getMetric(ASTUserClass node) {
        int publicMethods = (int)node.findChildrenOfType(ASTMethod.class).stream().filter(it -> it.getModifiers().isPublic() && !it.isSynthetic()).count();
        int publicFields = (int)node.findChildrenOfType(ASTFieldDeclarationStatements.class).stream().filter(it -> it.getModifiers().isPublic() && !it.getModifiers().isStatic()).count();
        return publicFields + publicMethods;
    }

    @Override
    protected Object[] getViolationParameters(ASTUserClass node, int metric, int limit) {
        return new Object[]{node.getSimpleName(), metric, limit};
    }
}

