/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AvoidHardcodingIdRule
extends AbstractApexRule {
    private static final Pattern PATTERN = Pattern.compile("^[a-zA-Z0-9]{5}0[a-zA-Z0-9]{9}([a-zA-Z0-5]{3})?$");
    private static final Map<String, Character> CHECKSUM_LOOKUP;

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTLiteralExpression.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTLiteralExpression node, Object data) {
        String literal;
        if (node.isString() && PATTERN.matcher(literal = node.getImage()).matches()) {
            if (literal.length() == 18 && !this.validateChecksum(literal)) {
                return data;
            }
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private boolean validateChecksum(String literal) {
        String part1 = literal.substring(0, 5);
        String part2 = literal.substring(5, 10);
        String part3 = literal.substring(10, 15);
        char checksum1 = this.checksum(part1);
        char checksum2 = this.checksum(part2);
        char checksum3 = this.checksum(part3);
        return literal.charAt(15) == checksum1 && literal.charAt(16) == checksum2 && literal.charAt(17) == checksum3;
    }

    private char checksum(String part) {
        StringBuilder sb = new StringBuilder(5);
        for (int i = 4; i >= 0; --i) {
            sb.append(Character.isUpperCase(part.charAt(i)) ? (char)'1' : '0');
        }
        return CHECKSUM_LOOKUP.get(sb.toString()).charValue();
    }

    static {
        HashMap<String, Character> lookup = new HashMap<String, Character>();
        char[] chartable = "ABCDEFGHIJKLMNOPQRSTUVWXYZ012345".toCharArray();
        for (int i = 0; i < chartable.length; ++i) {
            lookup.put(String.format("%5s", Integer.toBinaryString(i)).replace(' ', '0'), Character.valueOf(chartable[i]));
        }
        CHECKSUM_LOOKUP = Collections.unmodifiableMap(lookup);
    }
}

