/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MethodWithSameNameAsEnclosingClassRule
extends AbstractApexRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        String className = node.getImage();
        List methods = node.findDescendantsOfType(ASTMethod.class);
        for (ASTMethod m : methods) {
            String methodName = m.getImage();
            if (m.isConstructor() || !methodName.equalsIgnoreCase(className)) continue;
            this.addViolation(data, (Node)m);
        }
        return data;
    }
}

