/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;

public class OverrideBothEqualsAndHashcodeRule
extends AbstractApexRule {
    public OverrideBothEqualsAndHashcodeRule() {
        this.addRuleChainVisit(ASTUserClass.class);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        ASTMethod equalsNode = null;
        ASTMethod hashNode = null;
        for (ASTMethod method : node.findChildrenOfType(ASTMethod.class)) {
            if (equalsNode == null && this.isEquals(method)) {
                equalsNode = method;
            }
            if (hashNode == null && this.isHashCode(method)) {
                hashNode = method;
            }
            if (hashNode == null || equalsNode == null) continue;
            break;
        }
        if (equalsNode != null && hashNode == null) {
            this.addViolation(data, (Node)equalsNode);
        } else if (hashNode != null && equalsNode == null) {
            this.addViolation(data, (Node)hashNode);
        }
        return data;
    }

    private boolean isEquals(ASTMethod node) {
        int numParams = 0;
        String paramType = null;
        for (int ix = 0; ix < node.getNumChildren(); ++ix) {
            ApexNode sn = (ApexNode)node.getChild(ix);
            if (!(sn instanceof ASTParameter)) continue;
            ++numParams;
            paramType = ((ASTParameter)sn).getType();
        }
        return numParams == 1 && "equals".equalsIgnoreCase(node.getImage()) && "Object".equalsIgnoreCase(paramType);
    }

    private boolean isHashCode(ASTMethod node) {
        int numParams = 0;
        for (int ix = 0; ix < node.getNumChildren(); ++ix) {
            ApexNode sn = (ApexNode)node.getChild(ix);
            if (!(sn instanceof ASTParameter)) continue;
            ++numParams;
        }
        return numParams == 0 && "hashCode".equalsIgnoreCase(node.getImage());
    }
}

