/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.internal;

import net.sourceforge.pmd.lang.apex.ast.ASTApexFile;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.lang.rule.internal.CommonPropertyDescriptors;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractCounterCheckRule<T extends ApexNode<?>>
extends AbstractApexRule {
    private final PropertyDescriptor<Integer> reportLevel = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)CommonPropertyDescriptors.reportLevelProperty().desc("Threshold above which a node is reported")).require(NumericConstraints.positive())).defaultValue((Object)this.defaultReportLevel())).build();
    private final Class<T> nodeType;

    public AbstractCounterCheckRule(Class<T> nodeType) {
        this.nodeType = nodeType;
        this.definePropertyDescriptor(this.reportLevel);
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(this.nodeType, (Class[])new Class[0]);
    }

    protected abstract int defaultReportLevel();

    protected Object[] getViolationParameters(T node, int metric, int limit) {
        return new Object[]{metric, limit};
    }

    protected abstract int getMetric(T var1);

    protected boolean isIgnored(T node) {
        return false;
    }

    @Override
    public Object visit(ApexNode<?> node, Object data) {
        int limit;
        int metric;
        ApexNode<?> t = node;
        if (!this.isIgnored(t) && (metric = this.getMetric(t)) >= (limit = ((Integer)this.getProperty(this.reportLevel)).intValue())) {
            this.addViolation(data, (Node)node, this.getViolationParameters(t, metric, limit));
        }
        return data;
    }

    public static abstract class AbstractLineLengthCheckRule<T extends ApexNode<?>>
    extends AbstractCounterCheckRule<T> {
        public AbstractLineLengthCheckRule(Class<T> nodeType) {
            super(nodeType);
        }

        @Override
        protected int getMetric(T node) {
            Object measured = node;
            if (node instanceof ASTUserClass && node.getParent() instanceof ASTApexFile) {
                measured = node.getParent();
            }
            return measured.getEndLine() - measured.getBeginLine();
        }
    }
}

