/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.summit.ast.SourceLocation;
import com.google.summit.ast.declaration.MethodDeclaration;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexQualifiableNode;
import net.sourceforge.pmd.lang.apex.ast.ApexQualifiedName;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;
import net.sourceforge.pmd.lang.apex.ast.BaseApexClass;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.document.TextRegion;

public final class ASTMethod
extends AbstractApexNode
implements ApexQualifiableNode {
    private static final String CONSTRUCTOR_ID = "<init>";
    private static final String STATIC_INIT_ID = "<clinit>";
    private final String name;
    private final String internalName;
    private final List<String> parameterTypes;
    private final String returnType;
    private final SourceLocation sourceLocation;

    ASTMethod(String name, String internalName, List<String> parameterTypes, String returnType, SourceLocation sourceLocation) {
        this.name = name;
        this.internalName = internalName;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.sourceLocation = sourceLocation;
    }

    static ASTMethod fromNode(MethodDeclaration node) {
        String name;
        String internalName = name = node.getId().getString();
        if (node.isAnonymousInitializationCode()) {
            internalName = STATIC_INIT_ID;
        } else if (node.isConstructor()) {
            internalName = CONSTRUCTOR_ID;
        }
        return new ASTMethod(name, internalName, node.getParameterDeclarations().stream().map(p -> ASTMethod.caseNormalizedTypeIfPrimitive(p.getType().asCodeString())).collect(Collectors.toList()), ASTMethod.caseNormalizedTypeIfPrimitive(node.getReturnType().asCodeString()), node.getSourceLocation());
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    @Override
    void calculateTextRegion(TextDocument sourceCode) {
        if (this.sourceLocation.isUnknown()) {
            return;
        }
        this.setRegion(TextRegion.fromBothOffsets((int)sourceCode.offsetAtLineColumn(TextPos2d.pos2d((int)this.sourceLocation.getStartLine(), (int)(this.sourceLocation.getStartColumn() + 1))), (int)sourceCode.offsetAtLineColumn(TextPos2d.pos2d((int)this.sourceLocation.getEndLine(), (int)(this.sourceLocation.getEndColumn() + 1)))));
    }

    @Override
    public boolean hasRealLoc() {
        return !this.sourceLocation.isUnknown();
    }

    public String getImage() {
        BaseApexClass baseClassNode;
        if (this.isConstructor() && (baseClassNode = (BaseApexClass)this.ancestors(BaseApexClass.class).first()) != null) {
            return baseClassNode.getSimpleName();
        }
        return this.getCanonicalName();
    }

    public String getCanonicalName() {
        if (this.getParent() instanceof ASTProperty) {
            return ASTProperty.formatAccessorName((ASTProperty)this.getParent());
        }
        if (this.isConstructor()) {
            return CONSTRUCTOR_ID;
        }
        if (this.isStaticInitializer()) {
            return STATIC_INIT_ID;
        }
        return this.name;
    }

    @Override
    public ApexQualifiedName getQualifiedName() {
        return ApexQualifiedName.ofMethod(this);
    }

    public boolean isConstructor() {
        return CONSTRUCTOR_ID.equals(this.internalName);
    }

    public boolean isStaticInitializer() {
        return STATIC_INIT_ID.equals(this.internalName);
    }

    public ASTModifierNode getModifiers() {
        return (ASTModifierNode)this.firstChild(ASTModifierNode.class);
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int getArity() {
        return this.parameterTypes.size();
    }
}

