/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.bestpractices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTReferenceExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UnusedLocalVariableRule
extends AbstractApexRule {
    private static final Set<String> DATABASE_QUERY_METHODS = new HashSet<String>(Arrays.asList("Database.query".toLowerCase(Locale.ROOT), "Database.getQueryLocator".toLowerCase(Locale.ROOT), "Database.countQuery".toLowerCase(Locale.ROOT)));
    private static final Pattern BINDING_VARIABLE = Pattern.compile("(?i):\\s*+([_a-z0-9]+)");

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTVariableDeclaration.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        String variableName = node.getImage();
        ASTBlockStatement variableContext = (ASTBlockStatement)node.ancestors(ASTBlockStatement.class).first();
        if (variableContext == null) {
            return data;
        }
        ArrayList potentialUsages = new ArrayList();
        potentialUsages.addAll(variableContext.descendants(ASTVariableExpression.class).toList());
        potentialUsages.addAll(variableContext.descendants(ASTReferenceExpression.class).toList());
        for (ApexNode usage : potentialUsages) {
            if (usage.getParent() == node || !StringUtils.equalsIgnoreCase((CharSequence)variableName, (CharSequence)usage.getImage())) continue;
            return data;
        }
        List<String> soqlBindingVariables = this.findBindingsInSOQLStringLiterals(variableContext);
        if (soqlBindingVariables.contains(variableName.toLowerCase(Locale.ROOT))) {
            return data;
        }
        this.asCtx(data).addViolation((Node)node, new Object[]{variableName});
        return data;
    }

    private List<String> findBindingsInSOQLStringLiterals(ASTBlockStatement variableContext) {
        ArrayList<String> bindingVariables = new ArrayList<String>();
        List methodCalls = (List)variableContext.descendants(ASTMethodCallExpression.class).filter(m -> DATABASE_QUERY_METHODS.contains(m.getFullMethodName().toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        methodCalls.forEach(databaseMethodCall -> {
            ArrayList stringLiterals = new ArrayList();
            stringLiterals.addAll(databaseMethodCall.descendants(ASTLiteralExpression.class).filter(ASTLiteralExpression::isString).toStream().map(ASTLiteralExpression::getImage).collect(Collectors.toList()));
            databaseMethodCall.descendants(ASTVariableExpression.class).forEach(variableUsage -> {
                String referencedVariable = variableUsage.getImage();
                variableContext.descendants(ASTVariableExpression.class).filter(usage -> referencedVariable.equalsIgnoreCase(usage.getImage())).forEach(usage -> stringLiterals.addAll(((ApexNode)usage.getParent()).children(ASTLiteralExpression.class).filter(ASTLiteralExpression::isString).toStream().map(ASTLiteralExpression::getImage).collect(Collectors.toList())));
            });
            stringLiterals.forEach(s -> {
                Matcher matcher = BINDING_VARIABLE.matcher((CharSequence)s);
                while (matcher.find()) {
                    bindingVariables.add(matcher.group(1).toLowerCase(Locale.ROOT));
                }
            });
        });
        return bindingVariables;
    }
}

