/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.bestpractices;

import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class QueueableWithoutFinalizerRule
extends AbstractApexRule {
    private static final String EXECUTE = "execute";
    private static final String QUEUEABLE = "queueable";
    private static final String QUEUEABLE_CONTEXT = "queueablecontext";
    private static final String SYSTEM_ATTACH_FINALIZER = "system.attachfinalizer";

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTUserClass theClass, Object data) {
        if (!this.implementsTheQueueableInterface(theClass)) {
            return data;
        }
        for (ASTMethod theMethod : theClass.descendants(ASTMethod.class).toList()) {
            if (!this.isTheExecuteMethodOfTheQueueableInterface(theMethod) || this.callsTheSystemAttachFinalizerMethod(theMethod)) continue;
            this.asCtx(data).addViolation((Node)theMethod);
        }
        return data;
    }

    private boolean implementsTheQueueableInterface(ASTUserClass theClass) {
        for (String interfaceName : theClass.getInterfaceNames()) {
            if (!QUEUEABLE.equalsIgnoreCase(interfaceName)) continue;
            return true;
        }
        return false;
    }

    private boolean isTheExecuteMethodOfTheQueueableInterface(ASTMethod theMethod) {
        if (!EXECUTE.equalsIgnoreCase(theMethod.getCanonicalName())) {
            return false;
        }
        List parameters = theMethod.descendants(ASTParameter.class).toList();
        return parameters.size() == 1 && QUEUEABLE_CONTEXT.equalsIgnoreCase(((ASTParameter)parameters.get(0)).getType());
    }

    private boolean callsTheSystemAttachFinalizerMethod(ASTMethod theMethod) {
        for (ASTMethodCallExpression methodCallExpression : theMethod.descendants(ASTMethodCallExpression.class).toList()) {
            if (!SYSTEM_ATTACH_FINALIZER.equalsIgnoreCase(methodCallExpression.getFullMethodName())) continue;
            return true;
        }
        return false;
    }
}

