/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApexSuggestUsingNamedCredRule
extends AbstractApexRule {
    private static final String SET_HEADER = "setHeader";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CREDENTIAL_PREFIX = "{!$Credential.";
    private final Set<String> listOfAuthorizationVariables = new HashSet<String>();
    private final Set<String> listOfCredentialVariables = new HashSet<String>();

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTUserClass.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node)) {
            return data;
        }
        for (ASTVariableDeclaration varDecl : node.descendants(ASTVariableDeclaration.class)) {
            this.findAuthVariables(varDecl);
            this.findCredentialVariables(varDecl);
        }
        for (ASTField fDecl : node.descendants(ASTField.class)) {
            this.findAuthFields(fDecl);
            this.findCredentialFields(fDecl);
        }
        for (ASTMethodCallExpression method : node.descendants(ASTMethodCallExpression.class)) {
            this.flagAuthorizationHeaders(method, data);
        }
        this.listOfAuthorizationVariables.clear();
        this.listOfCredentialVariables.clear();
        return data;
    }

    private void findAuthVariables(ApexNode<?> node) {
        ASTVariableExpression variable;
        ASTLiteralExpression literal = (ASTLiteralExpression)node.firstChild(ASTLiteralExpression.class);
        if (literal != null && (variable = (ASTVariableExpression)node.firstChild(ASTVariableExpression.class)) != null && this.isAuthorizationLiteral(literal)) {
            this.listOfAuthorizationVariables.add(Helper.getFQVariableName(variable));
        }
    }

    private void findCredentialVariables(ApexNode<?> node) {
        ASTVariableExpression variable;
        ASTLiteralExpression literal = (ASTLiteralExpression)node.firstChild(ASTLiteralExpression.class);
        if (literal != null && (variable = (ASTVariableExpression)node.firstChild(ASTVariableExpression.class)) != null && this.isCredentialLiteral(literal)) {
            this.listOfCredentialVariables.add(Helper.getFQVariableName(variable));
        }
    }

    private void findAuthFields(ASTField fDecl) {
        if ("String".equals(fDecl.getType()) && AUTHORIZATION.equalsIgnoreCase(fDecl.getValue())) {
            this.listOfAuthorizationVariables.add(Helper.getFQVariableName(fDecl));
        }
    }

    private void findCredentialFields(ASTField fDecl) {
        if (!"String".equals(fDecl.getType())) {
            return;
        }
        String value = fDecl.getValue();
        if (value == null) {
            return;
        }
        if (value.contains(CREDENTIAL_PREFIX)) {
            this.listOfCredentialVariables.add(Helper.getFQVariableName(fDecl));
        }
    }

    private void flagAuthorizationHeaders(ASTMethodCallExpression node, Object data) {
        if (!Helper.isMethodName(node, SET_HEADER)) {
            return;
        }
        this.runChecks(node, data);
    }

    private void runChecks(ApexNode<?> node, Object data) {
        ApexNode keyNode = (ApexNode)node.getChild(1);
        ApexNode valueNode = (ApexNode)node.getChild(2);
        if (keyNode == null || !this.isAuthorizationReference(keyNode)) {
            return;
        }
        if (valueNode == null || !this.isCredentialReference(valueNode)) {
            this.asCtx(data).addViolation((Node)keyNode);
        }
    }

    private boolean isAuthorizationReference(ApexNode<?> node) {
        if (node instanceof ASTLiteralExpression) {
            return this.isAuthorizationLiteral((ASTLiteralExpression)node);
        }
        if (node instanceof ASTVariableExpression) {
            return this.isAuthorizationVariable((ASTVariableExpression)node);
        }
        return node instanceof ASTBinaryExpression && this.isAuthorizationReference((ApexNode)node.getChild(0));
    }

    private boolean isAuthorizationLiteral(ASTLiteralExpression literal) {
        return literal.isString() && AUTHORIZATION.equalsIgnoreCase(literal.getImage());
    }

    private boolean isAuthorizationVariable(ASTVariableExpression variable) {
        return this.listOfAuthorizationVariables.contains(Helper.getFQVariableName(variable));
    }

    private boolean isCredentialReference(ApexNode<?> node) {
        if (node instanceof ASTLiteralExpression) {
            return this.isCredentialLiteral((ASTLiteralExpression)node);
        }
        if (node instanceof ASTVariableExpression) {
            return this.isCredentialVariable((ASTVariableExpression)node);
        }
        return node instanceof ASTBinaryExpression && this.isCredentialBinaryExpression((ASTBinaryExpression)node);
    }

    private boolean isCredentialLiteral(ASTLiteralExpression literal) {
        return literal.isString() && literal.getImage().contains(CREDENTIAL_PREFIX);
    }

    private boolean isCredentialVariable(ASTVariableExpression variable) {
        return this.listOfCredentialVariables.contains(Helper.getFQVariableName(variable));
    }

    private boolean isCredentialBinaryExpression(ASTBinaryExpression binaryExpression) {
        for (int i = 0; i < binaryExpression.getNumChildren(); ++i) {
            if (!this.isCredentialReference((ApexNode)binaryExpression.getChild(i))) continue;
            return true;
        }
        return false;
    }
}

