/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import io.github.apexdevtools.apexparser.ApexLexer;
import io.github.apexdevtools.apexparser.CaseInsensitiveInputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.stream.Collectors;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.apex.ast.ASTCommentContainer;
import net.sourceforge.pmd.lang.apex.ast.ASTFormalComment;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.ast.LexException;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;

@InternalApi
final class ApexCommentBuilder {
    private final TextDocument sourceCode;
    private final CommentInformation commentInfo;

    ApexCommentBuilder(TextDocument sourceCode, String suppressMarker) {
        this.sourceCode = sourceCode;
        this.commentInfo = ApexCommentBuilder.extractInformationFromComments(sourceCode, suppressMarker);
    }

    public boolean containsComments(ASTCommentContainer commentContainer) {
        if (!commentContainer.hasRealLoc()) {
            return false;
        }
        TextRegion nodeRegion = commentContainer.getTextRegion();
        int index = Collections.binarySearch(this.commentInfo.allCommentsByStartIndex, nodeRegion.getStartOffset());
        assert (index < 0) : "comment token is at the same position as non-comment token";
        if ((index ^= 0xFFFFFFFF) >= 0 && index < this.commentInfo.allCommentsByStartIndex.size()) {
            int commentStartIndex = this.commentInfo.allCommentsByStartIndex.get(index);
            return nodeRegion.getStartOffset() < commentStartIndex && nodeRegion.getEndOffset() >= commentStartIndex;
        }
        return false;
    }

    public void addFormalComments() {
        for (ApexDocToken docToken : this.commentInfo.docTokens) {
            AbstractApexNode parent = docToken.nearestNode;
            if (parent == null) continue;
            ASTFormalComment comment = new ASTFormalComment(docToken.token);
            comment.calculateTextRegion(this.sourceCode);
            parent.insertChild(comment, 0);
        }
    }

    public void buildFormalComment(AbstractApexNode node) {
        if (!node.hasRealLoc()) {
            return;
        }
        TextRegion nodeRegion = node.getTextRegion();
        for (ApexDocToken docToken : this.commentInfo.docTokens) {
            if (docToken.token.getStartIndex() > nodeRegion.getStartOffset()) break;
            if (docToken.nearestNode != null && nodeRegion.compareTo(docToken.nearestNode.getTextRegion()) >= 0) continue;
            docToken.nearestNode = node;
        }
    }

    private static CommentInformation extractInformationFromComments(final TextDocument sourceCode, String suppressMarker) {
        boolean checkForCommentSuppression;
        String source = sourceCode.getText().toString();
        ApexLexer lexer = new ApexLexer((CharStream)new CaseInsensitiveInputStream((CharStream)CharStreams.fromString((String)source)));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new LexException(line, charPositionInLine, sourceCode.getFileId(), msg, (Throwable)e);
            }
        });
        ArrayList<Token> allCommentTokens = new ArrayList<Token>();
        HashMap<Integer, String> suppressMap = new HashMap<Integer, String>();
        int lastStartIndex = -1;
        Token token = lexer.nextToken();
        boolean bl = checkForCommentSuppression = suppressMarker != null;
        while (token.getType() != -1) {
            String trimmedCommentText;
            if (token.getChannel() == 3) {
                assert (lastStartIndex < token.getStartIndex()) : "Comments should be sorted";
                allCommentTokens.add(token);
            }
            if (checkForCommentSuppression && token.getType() == 251 && (trimmedCommentText = token.getText().substring(2).trim()).startsWith(suppressMarker)) {
                String userMessage = trimmedCommentText.substring(suppressMarker.length()).trim();
                suppressMap.put(token.getLine(), userMessage);
            }
            lastStartIndex = token.getStartIndex();
            token = lexer.nextToken();
        }
        return new CommentInformation(suppressMap, allCommentTokens);
    }

    public Map<Integer, String> getSuppressMap() {
        return this.commentInfo.suppressMap;
    }

    private static class ApexDocToken {
        AbstractApexNode nearestNode;
        Token token;

        ApexDocToken(Token token) {
            this.token = token;
        }
    }

    private static final class TokenListByStartIndex
    extends AbstractList<Integer>
    implements RandomAccess {
        private final List<Token> tokens;

        <T extends List<Token> & RandomAccess> TokenListByStartIndex(T tokens) {
            this.tokens = tokens;
        }

        @Override
        public Integer get(int index) {
            return this.tokens.get(index).getStartIndex();
        }

        @Override
        public int size() {
            return this.tokens.size();
        }
    }

    private static class CommentInformation {
        final Map<Integer, String> suppressMap;
        final List<Integer> allCommentsByStartIndex;
        final List<ApexDocToken> docTokens;

        CommentInformation(Map<Integer, String> suppressMap, List<Token> allCommentTokens) {
            this.suppressMap = suppressMap;
            this.docTokens = allCommentTokens.stream().filter(token -> token.getType() == 249).map(ApexDocToken::new).collect(Collectors.toList());
            this.allCommentsByStartIndex = new TokenListByStartIndex(new ArrayList<Token>(allCommentTokens));
        }
    }
}

