/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import com.google.summit.ast.Identifier;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitor;
import net.sourceforge.pmd.lang.apex.ast.ReferenceType;
import net.sourceforge.pmd.lang.rule.xpath.NoAttribute;

public final class ASTReferenceExpression
extends AbstractApexNode.Many<Identifier> {
    private final ReferenceType referenceType;
    private final boolean isSafe;

    ASTReferenceExpression(List<Identifier> identifiers, ReferenceType referenceType, boolean isSafe) {
        super(identifiers);
        this.referenceType = referenceType;
        this.isSafe = isSafe;
    }

    @Override
    protected <P, R> R acceptApexVisitor(ApexVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public String getImage() {
        if (!this.nodes.isEmpty()) {
            return ((Identifier)this.nodes.get(0)).getString();
        }
        return "";
    }

    @NoAttribute
    public List<String> getNames() {
        return this.nodes.stream().map(Identifier::getString).collect(Collectors.toList());
    }

    public boolean isSafeNav() {
        return this.isSafe;
    }

    public boolean isSObjectType() {
        return this.nodes.stream().anyMatch(id -> "sobjecttype".equalsIgnoreCase(id.getString()));
    }

    @Override
    public boolean hasRealLoc() {
        return !this.nodes.isEmpty();
    }
}

