/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.performance;

import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.rule.performance.AbstractAvoidNodeInLoopsRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class OperationWithHighCostInLoopRule
extends AbstractAvoidNodeInLoopsRule {
    private static final Set<String> SCHEMA_PERFORMANCE_METHODS = CollectionUtil.setOf((Object)"System.Schema.getGlobalDescribe", (Object[])new String[]{"Schema.getGlobalDescribe", "System.Schema.describeSObjects", "Schema.describeSObjects"}).stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTMethodCallExpression.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTMethodCallExpression node, Object data) {
        if (this.checkHighCostClassMethods(node)) {
            return this.checkForViolation(node, data);
        }
        return data;
    }

    private boolean checkHighCostClassMethods(ASTMethodCallExpression node) {
        return SCHEMA_PERFORMANCE_METHODS.contains(node.getFullMethodName().toLowerCase(Locale.ROOT));
    }
}

